package com.tourMate.services;

import com.tourMate.dto.PrincipalInfo;
import com.tourMate.entities.User;

import java.util.Date;
import java.util.List;

public interface UsersManager {
    public void createUser(String name, String surname, String email, Date birthDate, String address, String contact);

    public void deleteUser(long userID);

    public List<User> getCreatedUsers();

    public User findUserByID(long userID);

    public void editUser(long userID, String name, String surname, String email, Date birthDate, String address, String contact);
    public List<User> getUnapprovedUsers();
    public void approveUserProfile(long userId);

    void unlock(Long id);

    List<User> getAdmins();

    void connectAccount(Long id, String username, String password);

    List<User> findConnectedAccountsByUser(Long id);
    PrincipalInfo getPrincipalInfo(Long userId);
}
