package com.tourMate.services.impl;

import com.tourMate.dao.HotelDao;
import com.tourMate.dao.UsersDao;
import com.tourMate.dto.HotelDto;
import com.tourMate.dto.HotelReservationDto;
import com.tourMate.dto.HotelReservationUserDto;
import com.tourMate.entities.*;
import com.tourMate.services.HotelManager;
import com.tourMate.services.UsersManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.Duration;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class HotelManagerImpl implements HotelManager {

    @Autowired
    HotelDao hotelDao;
    @Autowired
    UsersDao usersDao;
    @Autowired
    UsersManager usersManager;

    @Override
    public void createHotel(String hotelName, String hotelDescripiton, String hotelLocation, String hotelEDBS, Boolean parking, Boolean petFriendly, Boolean internetAvailable) {

    }

    @Override
    public void createHotel(Hotels hotels, long userId) {
        User u = usersManager.findUserByID(userId);
        hotels.setOwner(u);
        hotelDao.createHotel(hotels);
    }


    @Override
    public List<Hotels> getHotels() {
        return hotelDao.getHotels();
    }

    @Override
    public List<Hotels> getHotelsForUser(long userId) {
        User u = usersManager.findUserByID(userId);
        return hotelDao.getHotelsForUser(u);
    }

    @Override
    public List<Hotels> getHotelsByLocation(String hotelLocation) {
        return hotelDao.getHotelsByLocation(hotelLocation);
    }

    @Override
    public void editHotel(long hotelId, String hotelName, String hotelDescripiton, String hotelLocation, String hotelEDBS, Boolean parking, Boolean petFriendly, Boolean internetAvailable) {
        Hotels hotel = hotelDao.findHotelByID(hotelId);
        hotel.setHotelName(hotelName);
        hotel.setHotelDescripiton(hotelDescripiton);
        hotel.setHotelLocation(hotelLocation);
        hotel.setHotelEDBS(hotelEDBS);
        hotel.setParking(parking);
        hotel.setPetFriendly(petFriendly);
        hotel.setInternetAvailable(internetAvailable);
        hotelDao.editHotel(hotel);
    }

    @Override
    public void deleteHotel(long hotelId) {
        Hotels h = findHotelByID(hotelId);
        hotelDao.deleteHotel(h);
    }

    @Override
    public Hotels findHotelByID(long hotelId) {
      return hotelDao.findHotelByID(hotelId);
    }

    @Override
    public List<HotelsImages> getHotelImages(Long hotelId) {
        Hotels h = hotelDao.findHotelByID(hotelId);
        return hotelDao.getHotelImages(h);
    }

    @Override
    public List<HotelRoom> getRoomsOfHotel(long hotelId) {
        Hotels h = findHotelByID(hotelId);
        return hotelDao.getRoomsOfHotel(h);
    }

    @Override
    public HotelRoom findRoomById(long hotelRoomId) {
        return hotelDao.findRoomById(hotelRoomId);
    }

    @Override
    public List<HotelRoomImages> getRoomImages(Long hotelRoom) {
        HotelRoom hr = hotelDao.findRoomById(hotelRoom);
        return hotelDao.getRoomImages(hr);
    }

    @Override
    public void addHotelImage(Long hotel, List<String> url)
    {
        Hotels h = findHotelByID(hotel);
        url.stream().map(file -> new HotelsImages(h, file)).forEach(x -> hotelDao.addHotelImage(x));
    }

    @Override
    public void deleteHotelImage(long hotelImageId){
        HotelsImages hotelsImages = findHotelImageById(hotelImageId);
        hotelDao.deleteHotelImage(hotelsImages);
    }

    @Override
    public HotelsImages findHotelImageById(long hotelImageId) {
        return hotelDao.findHotelImageById(hotelImageId);
    }

    @Override
    public void createRoom(Long hotelId, String hotelRoomDescription, String hotelRoomName, Boolean kitchenAvailable, Boolean airConditioning, Boolean balcony, double price, int numOfBeds) {
        Hotels hotel = findHotelByID(hotelId);
        HotelRoom hotelRoom = new HotelRoom(hotel, hotelRoomDescription, hotelRoomName, kitchenAvailable, airConditioning, balcony, price, numOfBeds);
        hotelDao.createRoom(hotelRoom);
    }

    @Override
    public void editRoom(long hotelRoomId, Hotels hotel, String hotelRoomDescription, String hotelRoomName, Boolean kitchenAvailable, Boolean airConditioning, Boolean balcony, double price) {
        HotelRoom hr = findRoomById(hotelRoomId);
        hr.setHotel(hotel);
        hr.setHotelRoomDescription(hotelRoomDescription);
        hr.setHotelRoomName(hotelRoomName);
        hr.setKitchenAvailable(kitchenAvailable);
        hr.setAirConditioning(airConditioning);
        hr.setBalcony(balcony);
        hr.setPrice(price);
        hotelDao.editRoom(hr);
    }

    @Override
    public void deleteRoom(long hotelRoomId) {
        HotelRoom hr = findRoomById(hotelRoomId);
        hotelDao.deleteRoom(hr);
    }


    @Override
    public List<HotelRoomAvailable> getRoomsAvailableById(Long id) {
        return hotelDao.getRoomsAvailable(id);
    }

    @Override
    public void createRoomAvailible(long hotelRoomId, Date dateFrom, Date dateTo, int numberOfBeds) {
        HotelRoom hotelRoom = findRoomById(hotelRoomId);
        HotelRoomAvailable hra = new HotelRoomAvailable(hotelRoom, dateFrom, dateTo, numberOfBeds);
        hotelDao.createRoomAvailible(hra);
    }

    @Override
    public void editRoomAvailible(long hotelRoomAvailableId, HotelRoom hotelRoom, Date dateFrom, Date dateTo, int numberOfBeds) {
        HotelRoomAvailable hr = findAvailibleRoomById(hotelRoomAvailableId);
        hr.setHotelRoom(hotelRoom);
        hr.setDateFrom(dateFrom);
        hr.setDateTo(dateTo);
        hr.setNumberOfBeds(numberOfBeds);
        hotelDao.editRoomAvailible(hr);
    }
    //01-01-2024 - 30-01-2024
    //05-01-2024 - 10-01-2024

    //01-01 - 05-01
    //10-01 - 30-01
    @Override
    public void editRoomAvailibleReservation(Long HotelRoomAvailableId, Long hotelRoomId, Date from, Date to, int numberOfBeds){
        HotelRoomAvailable roomAvailable = hotelDao.findAvailibleRoomById(HotelRoomAvailableId);
        roomAvailable.setNumberOfBeds(numberOfBeds-1);
        HotelRoom room = hotelDao.findRoomById(hotelRoomId);
        HotelRoomAvailable hra = new HotelRoomAvailable(room,roomAvailable.getDateFrom(),from,1);
        hotelDao.createRoomAvailible(hra);
        HotelRoomAvailable hra1 = new HotelRoomAvailable(room,to,roomAvailable.getDateTo(),1);
        hotelDao.createRoomAvailible(hra1);
    }

    @Override
    public void deleteRoomAvailible(long hotelRoomAvailableId) {
        HotelRoomAvailable hra = findAvailibleRoomById(hotelRoomAvailableId);
        hotelDao.deleteRoomAvailible(hra);
    }

    @Override
    public HotelRoomAvailable findAvailibleRoomById(long hotelRoomAvailableId) {
        return hotelDao.findAvailibleRoomById(hotelRoomAvailableId);
    }

    @Override
    public List<HotelRoomAvailable> getRoomsAvailibility() {
        return hotelDao.getRoomsAvailibility();
    }

    @Override
    public List<HotelRoomAvailable> getRoomsAvailibilityByHotel(Hotels hotel) {
       return hotelDao.getRoomsAvailibilityByHotel(hotel);
    }

    @Override
    public List<HotelRoomReservations> getReservationsInPeriod(String hotelLocation, Date dateFrom, Date dateTo)
    {
        return hotelDao.getReservationsInPeriod(hotelLocation, dateFrom, dateTo);
    }

    @Override
    public List<HotelDto> getRoomsAvailibilityByDateAndLocation(String hotelLocation, Date dateFrom, Date dateTo, int numberOfBeds, Boolean flexible) {
        long numberOfNights = Duration.between(dateFrom.toInstant(), dateTo.toInstant()).toDays();
        List<Hotels> hotels = getHotelsByLocation(hotelLocation);
        List<HotelRoomReservations> hotelRoomReservations = getReservationsInPeriod(hotelLocation, dateFrom, dateTo);
        List<Hotels> hotelsWithReservations = hotelRoomReservations.stream().map(x -> x.getHotelRoom().getHotel()).toList();
        List<Hotels> mostReservedHotels = hotelRoomReservations.stream()
                .collect(Collectors.groupingBy(x -> x.getHotelRoom().getHotel(), Collectors.counting())).entrySet().stream()
                .sorted(Map.Entry.comparingByValue(Comparator.reverseOrder()))
                .limit(5)
                .map(Map.Entry::getKey)
                .toList();
        List<Hotels> leastReservedHotels = hotelRoomReservations.stream()
                .collect(Collectors.groupingBy(x -> x.getHotelRoom().getHotel(), Collectors.counting())).entrySet().stream()
                .sorted(Map.Entry.comparingByValue())
                .limit(5)
                .map(Map.Entry::getKey)
                .toList();
        List<Hotels> hotelsWithoutReservations = hotels.stream().filter(x -> !hotelsWithReservations.contains(x)).toList();
        List<Hotels> hotelsToBeMarketed = new ArrayList<>();
        hotelsToBeMarketed.addAll(hotelsWithoutReservations);
        hotelsToBeMarketed.addAll(leastReservedHotels);
        List<HotelRoomAvailable> roomsAvailible = hotelDao.getRoomsAvailibilityByDateAndLocation(hotelLocation, dateFrom, dateTo, numberOfBeds, flexible);
        Map<Hotels, List<HotelRoomAvailable>> roomsByHotels = roomsAvailible.stream().collect(Collectors.groupingBy(x -> x.getHotelRoom().getHotel()));
        List<HotelDto> hotelsList = roomsByHotels.keySet().stream()
                .map(x -> new HotelDto(
                        x.getHotelId(),
                        x.getHotelName(),
                        x.getHotelDescripiton(),
                        x.getHotelLocation(),
                        x.getHotelEDBS(),
                        x.getParking(),
                        x.getPetFriendly(),
                        x.getInternetAvailable(),
                        roomsByHotels.get(x).stream().mapToDouble(y -> y.getHotelRoom().getPrice()).min().getAsDouble() * numberOfNights,
                        roomsByHotels.get(x),
                        getReviewsForHotel(x.getHotelId()),
                        getReviewsForHotel(x.getHotelId()).stream().mapToDouble(Reviews::getNumStar).average().orElse(0),
                        getHotelImages(x.getHotelId()),
                        mostReservedHotels.contains(x),
                        hotelsToBeMarketed.contains(x)
                )).toList();
        return hotelsList;
        //return hotelDao.getRoomsAvailibilityByDateAndLocation(hotelLocation, dateFrom, dateTo, numberOfBeds);
    }

    @Override
    // TODO:Transactional
    public void createReservation(Long userId, Long hotelRoomId, Long hotelRoomAvailableId, Date dateFrom, Date dateTo, Integer numberOfBeds) {
        HotelRoom room = hotelDao.findRoomById(hotelRoomId);
        User user = usersDao.findUserByID(userId);
        HotelRoomReservations r = new HotelRoomReservations(user, room, dateFrom, dateTo, numberOfBeds);
        editRoomAvailibleReservation(hotelRoomAvailableId, hotelRoomId, dateFrom, dateTo, numberOfBeds);
        hotelDao.createReservation(r);

    }

    @Override
    public void editReservation(long hotelRoomReservedId, User user, HotelRoom hotelRoom, Date dateFrom, Date dateTo, Integer numberOfBeds) {
        HotelRoomReservations hr = findReservationById(hotelRoomReservedId);
        hr.setUser(user);
        hr.setHotelRoom(hotelRoom);
        hr.setDateFrom(dateFrom);
        hr.setDateTo(dateTo);
        hr.setNumberOfBeds(numberOfBeds);
        hotelDao.editReservation(hr);
    }


    @Override
    public void deleteReservation(long hotelRoomReservedId) {
        HotelRoomReservations r = findReservationById(hotelRoomReservedId);
        HotelRoomAvailable hra = new HotelRoomAvailable(r.getHotelRoom(), r.getDateFrom(), r.getDateTo(), r.getNumberOfBeds());
        hotelDao.createRoomAvailible(hra);
        hotelDao.deleteReservation(r);
    }

    @Override
    public List<HotelReservationDto> findVaidReseravtionsByHotel(Long hotelId) {
        Hotels hotel = findHotelByID(hotelId);
        List<HotelRoomReservations> reservations = hotelDao.findReservationByHotel(hotel);
        return reservations.stream()
//                .filter(x -> x.getDateFrom().after(new Date()))
                .map(x -> new HotelReservationDto(
                        x.getUser(),
                        x.getHotelRoom(),
                        x.getDateFrom(),
                        x.getDateTo(),
                        x.getNumberOfBeds()
                )).toList();
    }

    @Override
    public List<HotelReservationUserDto> findValidHotelReservationsByUser(Long userId) {
        User u = usersDao.findUserByID(userId);
        List<HotelRoomReservations> reservations = hotelDao.findReservationByUser(u);
        return reservations.stream().map(x -> new HotelReservationUserDto(
                x.getHotelRoomReservedId(),
                x.getUser(),
                x.getHotelRoom(),
                x.getDateFrom(),
                x.getDateTo(),
                x.getNumberOfBeds(),
                x.getHotelRoom().getHotel().getHotelName(),
                x.getHotelRoom().getHotel().getHotelLocation(),
                "",
                x.getHotelRoom().getHotel().getHotelId(),
                x.getReviewed()
        )).toList();
    }

    @Override
    public HotelRoomReservations findReservationById(long hotelRoomReservedId) {
        return hotelDao.findReservationById(hotelRoomReservedId);
    }

    @Override
    public List<HotelRoomReservations> findReservationByUser(User user) {
        return hotelDao.findReservationByUser(user);
    }

    @Override
    public List<HotelRoomReservations> findReservationByHotel(Hotels hotel) {
        return hotelDao.findReservationByHotel(hotel);
    }

    @Override
    public List<HotelRoomReservations> getReservations() {
        return hotelDao.getReservations();
    }

    @Override
    public List<Reviews> getReviewsForHotel(Long hotelId) {
        Hotels hotel = findHotelByID(hotelId);
        return hotelDao.findReviewsByHotel(hotel);
    }

    @Override
    public List<HotelReservationUserDto> findPastHotelReservationsByUser(Long id) {
        User u = usersDao.findUserByID(id);
        List<HotelRoomReservations> reservations = hotelDao.findPastReservationByUser(u);
        return reservations.stream().map(x -> new HotelReservationUserDto(
                x.getHotelRoomReservedId(),
                x.getUser(),
                x.getHotelRoom(),
                x.getDateFrom(),
                x.getDateTo(),
                x.getNumberOfBeds(),
                x.getHotelRoom().getHotel().getHotelName(),
                x.getHotelRoom().getHotel().getHotelLocation(),
                "",
                x.getHotelRoom().getHotel().getHotelId(),
                x.getReviewed()
        )).toList();
    }

    @Override
    public void addRoomImage(Long id, List<String> filesToAdd) {
        HotelRoom hr = findRoomById(id);
        filesToAdd.stream().map(file -> new HotelRoomImages(hr, file)).forEach(x -> hotelDao.addRoomImage(x));
    }

    @Override
    public void setReservationReviewed(Long reservationId) {
        HotelRoomReservations hotelRoomReservations = findReservationById(reservationId);
        hotelRoomReservations.setReviewed(true);
        hotelDao.saveReservation(hotelRoomReservations);
    }
}
