package com.tourMate.services;

import com.tourMate.dto.HotelDto;
import com.tourMate.entities.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface HotelManager {
    void createHotel(String hotelName, String hotelDescripiton, String hotelLocation, String hotelEDBS, Boolean parking, Boolean petFriendly, Boolean internetAvailable);
    void createHotel(Hotels hotel, long userId);
    List<Hotels> getHotels();
    List<Hotels> getHotelsForUser(long userId);
    List<Hotels> getHotelsByLocation(String hotelLocation);
    void editHotel(long hotelId, String hotelName, String hotelDescripiton, String hotelLocation, String hotelEDBS, Boolean parking, Boolean petFriendly, Boolean internetAvailable);
    void deleteHotel(long hotelId);
    Hotels findHotelByID (long hotelId);
    public List<HotelsImages> getHotelImages(Long hotelId);
    public void addHotelImage(Long hotel, List<String> url);
    public void deleteHotelImage(long hotelImageId);
    public HotelsImages findHotelImageById(long hotelImageId);
    public List<HotelRoom> getRoomsOfHotel (long hotelId);
    public HotelRoom findRoomById (long hotelRoomId);
<<<<<<< HEAD
    public List<HotelRoomImages> getRoomImages(Long hotelRoom);
    public void createRoom(Hotels hotel, String hotelRoomDescription, String hotelRoomName, Boolean kitchenAvailable, Boolean airConditioning, Boolean balcony, double price, int numOfBeds);
=======
    public List<HotelRoomImages> getRoomImages(HotelRoom hotelRoom);
    public void createRoom(Hotels hotel, String hotelRoomDescription, String hotelRoomName, Boolean kitchenAvailable, Boolean airConditioning, Boolean balcony, double price);
>>>>>>> parent of ac19a0c (authContext impl, admin panel impl, search bar fixes, reservations listings impl)
    public void editRoom(long hotelRoomId, Hotels hotel, String hotelRoomDescription, String hotelRoomName, Boolean kitchenAvailable, Boolean airConditioning, Boolean balcony, double price);
    public void deleteRoom(long hotelRoomId);
    public List<HotelRoomAvailable> getRoomsAvailable(Long id);
    public void createRoomAvailible(HotelRoom hotelRoom, Date dateFrom, Date dateTo, int numberOfBeds);
    public void editRoomAvailible(long hotelRoomAvailableId, HotelRoom hotelRoom, Date dateFrom, Date dateTo, int numberOfBeds);
    public void editRoomAvailibleReservation(Long HotelRoomAvailableId, Long hotelRoomId, Date from, Date to, int numberOfBeds);
    public void deleteRoomAvailible(long hotelRoomAvailableId);
    public HotelRoomAvailable findAvailibleRoomById(long hotelRoomAvailableId);
    public List<HotelRoomAvailable> getRoomsAvailibility();
    public List<HotelRoomAvailable> getRoomsAvailibilityByHotel(Hotels hotel);
    public List<HotelDto> getRoomsAvailibilityByDateAndLocation(String hotelLocation, Date dateFrom, Date dateTo, int numberOfBeds);
    public void createReservation(Long userId, Long hotelRoomId, Long hotelRoomAvailableId, Date dateFrom, Date dateTo, Integer numberOfBeds);
    public void editReservation(long hotelRoomReservedId, User user, HotelRoom hotelRoom, Date dateFrom, Date dateTo, Integer numberOfBeds);
    public void deleteReservation(long hotelRoomReservedId);
    public HotelRoomReservations findReservationById(long hotelRoomReservedId);
    public List<HotelRoomReservations> findReservationByUser(User user);
    public List<HotelRoomReservations> findReservationByHotel(Hotels hotel);
    public List<HotelRoomReservations> getReservations();
    public List<Reviews> getReviewsForHotel(Long hotelId);

    List<HotelReservationUserDto> findPastHotelReservationsByUser(Long id);

    void addRoomImage(Long id, List<String> filesToAdd);
}
