import logo from './logo.svg';
import './App.css';
import Navigation from './Components/Layout/Navbar/Navigation';
import 'bootstrap/dist/css/bootstrap.css';
import 'bootstrap/dist/js/bootstrap.js';
import HomeCarousel from './Components/Layout/CarouselHome/Carousel';
import {Card, Container} from 'react-bootstrap';
import TabComponent from './Components/Tab/Tab';
import Offers from './Components/Layout/Offers/Offers';
import MostVisitedBar from './Components/MostVisited/MostVisitedBar';
import Review from './Components/BecomeAHost/Review';
import MostPopularRoutesCont from './Components/MostPopularRoutes/MostPopularRoutesCont';
import BecomeAHost from "./Components/BecomeAHost/BecomeAHost"
import HomePage from './Pages/HomePage';
import LoginPage from './Pages/LoginPage';
import RegistrationPage from './Pages/RegistrationPage'
import SearchPage from './Pages/SearchPage';
import HotelDetailsPage from './Pages/HotelDetailsPage';
import ProfilePage from './Pages/ProfilePage';
import ResourcesPage from './Pages/ResourcesPage';
import LoginForm from './Components/Login/LoginForm';
import StaticExample from './Components/Modal';
import TransportDetailsPage from './Pages/TransportDetailsPage';
import NoBusinessRegisteredError from './Pages/NoBusinessRegisteredError';
import HotelEditPage from './Pages/HotelEditPage';
import RestaurantEditPage from './Pages/RestaurantEditPage';
import TransportEditPage from './Pages/TransportEditPage';
import RestaurantDetailsPage from './Pages/RestaurantDetailsPage';
import {BrowserRouter, Route, Routes} from 'react-router-dom';
import LoginErrorPage from "./Pages/LoginErrorPage";
import {AuthProvider} from "./Components/Context/AuthContext";
import PrivateRoute from "./Components/Misc/PrivateRoute";
import ProfilesManagementPage from "./Pages/ProfilesManagementPage";
import UserReservationsManagement from "./Pages/UserReservationsManagement";


function App() {

    return (
        <div className="App" style={{overflow: 'hidden'}}>
            <AuthProvider>
                <BrowserRouter>
                    <Routes>
                        <Route path='/login' element={<LoginPage/>}/>
                        <Route path='/register' element={<RegistrationPage/>}/>
                        <Route path='/profile' element={<PrivateRoute><ProfilePage/></PrivateRoute>}/>
                        <Route path='/profiles' element={<PrivateRoute><ProfilesManagementPage/></PrivateRoute>}/>
                        <Route path='/reservations' element={<PrivateRoute><UserReservationsManagement/></PrivateRoute>}/>
                        <Route path="/resources" exact element={<PrivateRoute><NoBusinessRegisteredError
                            hasRegistration="false"/></PrivateRoute>}/>
                        <Route path="/resources/hotel"
                               element={<PrivateRoute><ResourcesPage tab="/hotel"/></PrivateRoute>}/>
                        <Route path="/resources/hotel/:hotelId" element={<PrivateRoute><HotelEditPage/></PrivateRoute>}/>
                        <Route path="/resources/restaurant"
                               element={<PrivateRoute><ResourcesPage tab="/restaurant"/></PrivateRoute>}/>
                        <Route path='/resources/restaurant/:restaurantId'
                               element={<PrivateRoute><RestaurantEditPage/></PrivateRoute>}/>
                        <Route path="/resources/transport"
                               element={<PrivateRoute><ResourcesPage tab="/transport"/></PrivateRoute>}/>
                        <Route path="/resources/transport/:transportId"
                               element={<PrivateRoute><TransportEditPage/></PrivateRoute>}/>
                        <Route path="/home" element={<HomePage/>}/>
                        <Route path="/error" element={<LoginErrorPage/>}/>
                        <Route path='/details/transport' element={<TransportDetailsPage></TransportDetailsPage>}/>
                        <Route path='/details/hotel' element={<HotelDetailsPage></HotelDetailsPage>}/>
                        <Route path='/details/restaurant' element={<RestaurantDetailsPage></RestaurantDetailsPage>}/>
                        <Route path="/search/hotel/:hotelLocation/:dateFrom/:dateTo/:numBeds"
                               element={<SearchPage type="hotel"/>}/>
                        <Route path="/search/transport/:from/:to/:date/:numPassengers"
                               element={<SearchPage type="transport"/>}/>
                        <Route path="/search/restaurant/:restaurantLocation/:date/:hourFrom/:hourTo/:numPeople"
                               element={<SearchPage type="restaurant"/>}/>
                    </Routes>
                </BrowserRouter>
            </AuthProvider>
        </div>
    );
}

export default App;
