import useGet from "../Hooks/useGet";
import {Container} from "react-bootstrap";
import {FaCheckCircle} from "react-icons/fa";
import React from "react";
import useApprove from "../Hooks/useApprove";

const UnapprovedBusinessesTable = () => {

    const { data, isLoading, setData, getData, setChanged } = useGet('/business/unapproved');
    const { getData: approveBusiness} = useApprove();

    return (
        <>
            <Container fluid >
                <table className="table table-hover">
                    <thead>
                    <tr>
                        <th scope="col">Ред. бр.</th>
                        <th scope="col">Име на фирма</th>
                        <th scope="col">Адреса</th>
                        <th scope="col">Даночен број</th>
                        <th scope="col">Одговорно лице</th>
                        <th>Одобри</th>
                    </tr>
                    </thead>
                    <tbody>
                    {!isLoading && data.map((f, i) => { return <tr key={f.businessId}>
                        <th style={{verticalAlign: "middle"}} scope="row">{i + 1}</th>
                        <td style={{verticalAlign: "middle"}}>{f.name}</td>
                        <td style={{verticalAlign: "middle"}}>{f.address}</td>
                        <td style={{verticalAlign: "middle"}}>{f.edbs}</td>
                        <td style={{verticalAlign: "middle"}}>{f.user.name + " " + f.user.surname}</td>
                        <td style={{verticalAlign: "middle"}}><FaCheckCircle size={'2.2em'} color={'#159895'} onClick={() => {
                            approveBusiness('/business/approve/' + f.businessId).then(() => {
                                setChanged((prev) => {
                                    return Math.random();
                                })
                            })
                        }}/></td>
                    </tr>})}
                    </tbody>
                </table>
            </Container>
        </>
    )
}

export default UnapprovedBusinessesTable;