import axios from "../../../axios";
import { useState } from "react";

const useFileChange = () => {
    const [selectedFiles, setSelectedFiles] = useState([]);

    const onFileChangeHandler = (files, type, id, refresh) => {
        setSelectedFiles(files);

        const formData = new FormData();

        files.forEach((x) => formData.append('files', x))
        //
        // for (let i = 0; i < files.length; i++) {
        //
        // }


        axios.post(`/upload/${type}/${id}`, formData, {
            headers: {
                'Content-Type': 'multipart/form-data'
            }
        })
            .then(res => {
                if (res.status === 200) {
                    console.log(res.data);
                    refresh((prev) => ++prev)
                    alert("File(s) uploaded successfully.");
                } else {
                    console.error("File upload failed:", res.data);
                    alert("File upload failed.");
                }
            })
            .catch(error => {
                console.error("Error uploading file(s):", error);
                alert("An error occurred while uploading files.");
            });
    };

    return { onFileChangeHandler, selectedFiles };
};

export default useFileChange;
