import {Col, Container, Row} from "react-bootstrap";
import React from "react";

const ReservationListing = (props) => {
    return(
        <>
            <Container className="py-3 px-1 my-4"
                       style={{
                           border: "4px solid #159895",
                           borderRadius: "1em",
                           boxShadow: "0 3px 5px #159895",
                           maxWidth: "90%",
                       }}>
                <Row>
                    <Col md={8} className="d-flex flex-column justify-content-start ps-5">
                        <h3 style={{fontWeight: "bold"}} className={'text-start'}>Резервација за:</h3>
                        <h4 className={'text-start'}>{props.data.hotelRoom.hotelRoomName}</h4>
                        <h4 className={'text-start'}>{props.data.user.name + ' ' + props.data.user.surname}</h4>
                        <h5 className={'text-start'}>{props.data.dateFrom + ' - ' + props.data.dateTo}</h5>
                    </Col>
                    <Col md={4} className="d-flex flex-column justify-content-center align-content-center">
                        <h3>Вкупна цена: <br></br>{props.data.hotelRoom.price}$</h3>
                    </Col>
                </Row>
            </Container>
        </>
    )
}

export default ReservationListing;