import React from "react";
import { Container, Form, Button, Row, Col } from "react-bootstrap";
import useFormData from "../Hooks/useFormData";
import SearchCriteriasHotel from "./SearchCriteriasHotel";
import SearchCriteriasTransport from "./SearchCriteriasTransport";
import SearchCriteriasRestaurant from "./SearchCriteriasRestaurant";

const SearchCriteriasBar = (props) => {

    const { criterias, type } = props

    return (
        <>
            {type === 'hotel' && <SearchCriteriasHotel criterias={criterias}/>}
            {type === 'transport' && <SearchCriteriasTransport showButton={props.showButton} criterias={criterias}/>}
            {type === 'restaurant' && <SearchCriteriasRestaurant criterias={criterias}/>}
        </>
    )
}

export default SearchCriteriasBar;