import React from "react";
import {Button, Col, Container, Form, Row} from "react-bootstrap";
import {HiMagnifyingGlass} from "react-icons/hi2"
import useFormData from "../Hooks/useFormData";

const timeOfArrival = () => {
    let times = [];

    for (let i = 0; i <= 23; i++) {
        for (let j = 0; j <= 30; j += 30) {
            let hour = i.toString().padStart(2, "0");
            let minutes = j.toString().padStart(2, "0");
            times.push(`${hour}:${minutes}`);
        }
    }

    return times;
};
function TabFormRestaurant() {
    const {formData, onFormChange, setFormData} = useFormData({
        restaurantLocation: '',
        date: '',
        hourFrom: '',
        hourTo: '',
        numPeople: ''
    })


    const a = timeOfArrival();

    return (
        <Form>
            <Row>
                <Col>
                    <Form.Floating className="mb-3">
                        <Form.Control
                            size="lg"
                            type="text"
                            placeholder="Место:"
                            id="location"
                            name={'restaurantLocation'}
                            value={formData.restaurantLocation}
                            onChange={onFormChange}
                        ></Form.Control>
                        <label htmlFor="location">Место:</label>
                    </Form.Floating>
                </Col>
                <Col>
                    <Form.Floating className="mb-3">
                        <Form.Control
                            size="md"
                            type="date"
                            step={3600000}
                            placeholder="Час од:"
                            id="dateFrom"
                            name={'date'}
                            value={formData.date}
                            onChange={onFormChange}
                        ></Form.Control>
                        <label htmlFor="dateFrom">Датум:</label>
                    </Form.Floating>
                </Col>
                <Col>
                    <Form.Floating className="mb-3">
                        <Form.Select size="md"
                         name={'hourFrom'}
                         value={formData.hourFrom}
                         onChange={onFormChange}>
                            <option>Изберете време:</option>
                            {a.map((x) => {
                                return <option key={x}>{x}</option>;
                            })}
                        </Form.Select>
                        <label htmlFor="hour">Час од:</label>
                    </Form.Floating>
                </Col>
                <Col>
                    <Form.Floating className="mb-3">
                        <Form.Select size="md"
                         name={'hourTo'}
                         value={formData.hourTo}
                         onChange={onFormChange}>
                            <option>Изберете време:</option>
                            {a.filter((x) => x > formData.hourFrom).map((x) => {
                                return <option key={x}>{x}</option>;
                            })}
                        </Form.Select>
                        <label htmlFor="hour">Час до:</label>
                    </Form.Floating>
                </Col>
                <Col>
                    <Form.Floating className="mb-3">
                        <Form.Control
                            size="md"
                            type="number"
                            placeholder="Број на гости:"
                            id="floatingPassengers"
                            name={'numPeople'}
                            value={formData.numPeople}
                            onChange={onFormChange}
                        ></Form.Control>
                        <label htmlFor="floatingPassengers">Број на гости:</label>
                    </Form.Floating>
                    <Form.Group className="my-1">
                        <Button type="submit" style={{backgroundColor: "#159895"}} size="lg" onClick={(e) => {
                            e.preventDefault();
                            window.location.href = `/search/restaurant/${formData.restaurantLocation}/${formData.date}/${formData.hourFrom}/${formData.hourTo}/${formData.numPeople}`

                        }}>
                            <span className="ikona my-1"><HiMagnifyingGlass/></span>
                            <span className="ikona mx-3">Пребарај</span>
                        </Button>
                    </Form.Group>
                </Col>
            </Row>
        </Form>
    );
}

export default TabFormRestaurant;
