import HotelReservationListing from "./HotelReservationListing";
import React from "react";
import useGet from "../Hooks/useGet";

const ActiveHotelReservations = () => {

    const {data, isLoading, setData, getData, setChanged} = useGet('/hotel/reservations/user/1')

    return (
        <>
            {!isLoading && data.map((res) => {
                return (<HotelReservationListing data={res} type={'hotel'}></HotelReservationListing>)
            })}

            {(!isLoading && data.length === 0) && <h3 className={'my-5'}>Нема податоци за одбраните критериуми!</h3>}
        </>
    )
}

export default ActiveHotelReservations;