import HotelReservationListing from "./HotelReservationListing";
import React from "react";
import useGet from "../Hooks/useGet";

const PastRestaurantReservations = () => {

    const {data, isLoading, setData, getData, setChanged} = useGet('/restaurant/reservations/user/1/past')
    !isLoading && console.log(data)

    return (
        <>
            {!isLoading && data.map((res) => {
                return (<HotelReservationListing past={true} data={res} type={'restaurant'}></HotelReservationListing>)
            })}
            {(!isLoading && data.length === 0) && <h3 className={'my-5'}>Нема податоци за одбраните критериуми!</h3>}
        </>
    )
}

export default PastRestaurantReservations;