import React, {useState} from "react";
import {Container, Nav, Tabs} from "react-bootstrap";
import {Tab} from "react-bootstrap";
import {FaHotel, FaTaxi} from 'react-icons/fa'
import {MdRestaurant} from "react-icons/md"
import HotelReservationListing from "./HotelReservationListing";
import UnapprovedBusinessesTable from "../AdminPanel/UnapprovedBusinessesTable";
import UnapprovedProfilesTable from "../AdminPanel/UnapprovedProfilesTable";
import AllProfilesTable from "../AdminPanel/AllProfilesTable";
import useGet from "../Hooks/useGet";
import ActiveHotelReservations from "./ActiveHotelReservations";
import PastHotelReservations from "./PastHotelReservations";
import ActiveRestaurantReservations from "./ActiveRestaurantReservations";
import PastRestaurantReservations from "./PastRestaurantReservations";
import ActiveTransportReservations from "./ActiveTransportReservations";
import PastTransportReservations from "./PastTransportReservations";

function TypeSelectionTab() {
    const [activeTab, setActiveTab] = useState("/hotel");
    const handleSelect = (eventKey) => {
        setActiveTab(eventKey);
    };


    return (
        <Container className='rounded-5'>
            <Tab.Container
                activeKey={activeTab}
                onSelect={handleSelect}
                className="bg-dark rounded-5"
            >
                <Nav
                    fill
                    variant="tabs"
                    className="bg-body rounded-top-5"
                    activeKey="/hotel"
                    id="tab_item"
                >
                    <Nav.Item className="tab_item rounded-5">
                        <Nav.Link eventKey="/hotel" className="text-left rounded-5">
                            <span className="ikona"><FaHotel color="#159895" style={{lineHeight: "100em"}}
                                                             size={"1.5em"} className="mx-3"/></span>
                            <span className="ikona">Сместување</span>
                        </Nav.Link>
                    </Nav.Item>
                    <Nav.Item className="tab_item">
                        <Nav.Link eventKey="/restaurant">
                            <span className="ikona"><MdRestaurant color="#159895" size={"1.5em"}
                                                                  className="mx-3"/></span><
                            span className="ikona">Ресторан</span>
                        </Nav.Link>
                    </Nav.Item>
                    <Nav.Item className="tab_item rounded-5">
                        <Nav.Link eventKey="/transport" className="text-left rounded-5"><span className="ikona"><FaTaxi
                            color="#159895" size={"1.5em"} className="mx-3"/></span>
                            <span className="ikona">Превоз</span>
                        </Nav.Link>
                    </Nav.Item>
                </Nav>

                <Tab.Content className="py-5 px-3 border rounded-bottom-5 bg-light">
                    <Tab.Pane eventKey="/hotel">
                        <Container>
                            <Tabs
                                fill
                                defaultActiveKey="home"
                                id="uncontrolled-tab-example"
                                className="mb-3"
                            >
                                <Tab eventKey="home" title="Активни резервации">
                                    <ActiveHotelReservations></ActiveHotelReservations>
                                </Tab>
                                <Tab eventKey="profile" title="Претходни резервации">
                                    <PastHotelReservations></PastHotelReservations>
                                </Tab>
                            </Tabs>
                        </Container>
                    </Tab.Pane>
                    <Tab.Pane eventKey="/restaurant">
                        <Tabs
                            fill
                            defaultActiveKey="home"
                            id="uncontrolled-tab-example"
                            className="mb-3"
                        >
                            <Tab eventKey="home" title="Активни резервации">
                                <ActiveRestaurantReservations></ActiveRestaurantReservations>
                            </Tab>
                            <Tab eventKey="profile" title="Претходни резервации">
                                <PastRestaurantReservations></PastRestaurantReservations>
                            </Tab>
                        </Tabs>
                    </Tab.Pane>
                    <Tab.Pane eventKey="/transport">
                        <Tabs
                            fill
                            defaultActiveKey="home"
                            id="uncontrolled-tab-example"
                            className="mb-3"
                        >
                            <Tab eventKey="home" title="Активни резервации">
                                <ActiveTransportReservations></ActiveTransportReservations>
                            </Tab>
                            <Tab eventKey="profile" title="Претходни резервации">
                                <PastTransportReservations></PastTransportReservations>
                            </Tab>
                        </Tabs>
                    </Tab.Pane>
                </Tab.Content>
            </Tab.Container>
        </Container>
    );
}

export default TypeSelectionTab;
