import React from "react";
import LoginForm from "../Components/Login/LoginForm";
import {Container, Row, Col, Form, Image, Button, Modal} from "react-bootstrap";
import Navigation from "../Components/Layout/Navbar/Navigation";
import Carousel from "react-bootstrap/Carousel";
import {useState} from "react";
import DescriptionContainer from "../Components/HotelDetails/DescriptionContainer";
import ReviewsCarousel from "../Components/HotelDetails/ReviewsCarousel";
import RoomsTable from "../Components/HotelDetails/RoomsTable";
import ContactBar from "../Components/HotelDetails/ContactBar";
import RouteContainer from "../Components/TransportDetails/RouteContainer";
import {useLocation, useParams} from "react-router-dom";
import SearchCriteriasTransport from "../Components/SearchCriterias/SearchCriteriasTransport";
import SearchCriteriasBar from "../Components/SearchCriterias/SearchCriteriasBar";
import useCreate from "../Components/Hooks/useCreate";

const TransportDetailsPage = (props) => {
    document.body.style.backgroundColor = "white";
    const {createEntity} = useCreate()

    const [index, setIndex] = useState(0);
    const [getData, setData] = useState(0);

    const location = useLocation();
    const {data, params} = location.state;
    const [show, setShow] = useState(false);
    const handleClose = () => setShow(false);
    const handleShow = () => setShow(true);
    const route = data.transportRoutes.filter(x => x.from === params.from && x.to === params.to)[0];
    const dateFormatter = (str) => {
        const inputDate = new Date(str);

        const options = {
            year: 'numeric',
            month: '2-digit',
            day: '2-digit',
            hour12: false,
            hour: '2-digit',
            minute: '2-digit'
        };

        return inputDate.toLocaleString('de-DE', options);

    }

    const handleSelect = (selectedIndex) => {
        setIndex(selectedIndex);
    };

    return (
        <>
            <Navigation/>
            <Container className="my-3">
                <Row>
                    <span><h2 style={{color: "#159895", textAlign: 'left'}}>Вашето пребарување</h2></span>
                </Row>
                <SearchCriteriasBar type={'transport'} showButton={false} criterias={params}></SearchCriteriasBar>
                <Row className="d-flex justify-content-between">
                    <Col style={{textAlign: "left"}}>
                        <span>
                            <h3 style={{color: "#159895"}}><b>Резултантна рута</b></h3>
                            <h2 style={{color: "#159895"}}>{data.from} - {data.to}</h2>
                            <h5 style={{color: "#159895"}}>({data.routes.join(", ")})</h5>
                        </span>
                    </Col>
                    <Col>
                        <Container>
                            <Row className="mb-4">
                                <Col style={{textAlign: "right"}}>
                  <span
                      style={{
                          backgroundColor: "#159895",
                          padding: "0.75em",
                          fontWeight: "bold",
                          fontSize: "1.25rem",
                          borderRadius: "0.75em",
                          color: "white",
                      }}
                  >
                    9.1
                  </span>
                                </Col>
                            </Row>
                        </Container>
                    </Col>
                </Row>
                <Row>
                    <RouteContainer data={data}></RouteContainer>
                </Row>
                <hr></hr>
                <Row>
                    <Col>
                        <h3>Одбрана рута</h3>
                    </Col>
                    <Col>
                        <h3>{params.from + ' - ' + params.to}</h3>
                    </Col>
                </Row>
                <hr></hr>
                <Row>
                    <Col>
                        <h3>Очекувано време на поаѓање</h3>
                    </Col>
                    <Col>
                        <h3>{dateFormatter(route.departure)}</h3>
                    </Col>
                </Row>
                <hr></hr>
                <Row>
                    <Col>
                        <h3>Цена</h3>
                    </Col>
                    <Col>
                        <h3>{data.price}$</h3>
                    </Col>
                </Row>
                <hr></hr>
                <Row>
                    <Col className="d-flex flex-column justify-content-center">
                        <h3>Возач</h3>
                    </Col>
                    <Col className="d-flex flex-column justify-content-center">
                        <Container className="d-flex flex-row justify-content-center mb-3" style={{paddingLeft: "28%"}}>
                            <Col className="d-flex flex-column justify-content-center" style={{maxWidth: "30%"}}>
                                <Image
                                    src="https://t3.ftcdn.net/jpg/05/16/27/58/360_F_516275801_f3Fsp17x6HQK0xQgDQEELoTuERO4SsWV.jpg"
                                    style={{
                                        height: "4em",
                                        borderRadius: "50%",
                                        maxWidth: "100%",
                                    }}
                                    className="m-auto"
                                ></Image>
                            </Col>
                            <Col className="d-flex flex-column justify-content-center">
                                <Container className="pt-2" style={{textAlign: "left"}}>
                                    <h4>{data.transport.owner.name} {data.transport.owner.surname.substring(0, 1)}.</h4>
                                </Container>
                            </Col>
                        </Container>
                    </Col>
                </Row>
                <hr></hr>
                <Row>
                    <Col>
                        <h3>Возило</h3>
                    </Col>
                    <Col>
                        <h3>{data.transport.carBrand + " " + data.transport.carType}</h3>
                    </Col>
                </Row>
                <hr></hr>
                <Row>
                    <Col className="d-flex flex-column justify-content-center">
                        <h3>Број на патници</h3>
                    </Col>
                    <Col md="auto" className="d-flex flex-column justify-content-center">
                        <Form.Select onChange={(e) => {
                            setData(e.target.value)
                        }} aria-label="Default select example">
                            <option></option>
                            {[...Array(route.freeSpace).keys()].map(x => {
                                return (
                                    <option value={x+1}  >{x + 1}</option>
                                )
                            })}
                        </Form.Select>
                    </Col>
                    <Col>
                        <Button className="m-2" size="lg" style={{backgroundColor: "#159895"}} onClick={handleShow}>Резервирај</Button>
                    </Col>
                </Row>
                <Row><ContactBar></ContactBar></Row>
            </Container>

            <Modal show={show} size={'lg'} onHide={handleClose}>
                <Modal.Header closeButton>
                    <Modal.Title>Потврда на резервација</Modal.Title>
                </Modal.Header>
                <Modal.Body>
                    <h4>Резервација на рута</h4>
                    <h3>{route.from + ' ' + route.to}</h3>
                    <h4>Време на поаѓање:<b>{' ' + dateFormatter(route.departure)}</b></h4>
                    <h4>Време на престигнување:<b>{' ' + dateFormatter(route.arrival)}</b></h4>
                    <h4>Број на патници:<b>{' ' + getData}</b></h4>
                </Modal.Body>
                <Modal.Footer>
                    <Button variant="secondary" onClick={handleClose}>
                        Close
                    </Button>
                    <Button variant="primary" onClick={() => {
                        createEntity('transport/reserve', {
                            transportRouteId: route.routeId,
                            userId: 1,
                            numSeats: getData
                        })
                        handleClose();
                    }}>
                        Резервирај
                    </Button>
                </Modal.Footer>
            </Modal>
        </>
    );
};

export default TransportDetailsPage;
