package com.tourMate.dto;
import com.tourMate.entities.HotelRoom;
import com.tourMate.entities.RestaurantsTable;
import com.tourMate.entities.User;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

public class RestaurantReservationUserDto {
    private User user;
    private RestaurantsTable restaurantsTable;
    private Long restaurantId;
    @DateTimeFormat(pattern = "dd.MM.yyyy")
    private Date dateFrom;
    @DateTimeFormat(pattern = "dd.MM.yyyy")
    private Date dateTo;
    private Integer numPeople;
    private String restaurantName;
    private String restaurantLocation;
    private String restaurantAddress;
    private Boolean reviewed;

    public RestaurantReservationUserDto(User user, RestaurantsTable restaurantsTable, Date dateFrom, Date dateTo, Integer numPeople, String restaurantName, String restaurantLocation, String restaurantAddress, Long restaurantId, Boolean reviewed) {
        this.user = user;
        this.restaurantsTable = restaurantsTable;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.numPeople = numPeople;
        this.restaurantLocation = restaurantLocation;
        this.restaurantName = restaurantName;
        this.restaurantAddress = restaurantAddress;
        this.restaurantId = restaurantId;
        this.reviewed = reviewed;
    }

    public User getUser() {
        return user;
    }

    public RestaurantsTable getRestaurantsTable() {
        return restaurantsTable;
    }

    public Long getRestaurantId() {
        return restaurantId;
    }

    public Date getDateFrom() {
        return dateFrom;
    }

    public Date getDateTo() {
        return dateTo;
    }

    public Integer getNumPeople() {
        return numPeople;
    }

    public String getRestaurantName() {
        return restaurantName;
    }

    public String getRestaurantLocation() {
        return restaurantLocation;
    }

    public String getRestaurantAddress() {
        return restaurantAddress;
    }

    public Boolean getReviewed() {
        return reviewed;
    }
}
