import React from "react";
import useGet from "../Hooks/useGet";
import {Col, Container, Row, Table} from "react-bootstrap";
import AddRoomForm from "./AddRoomForm";
import AddTripForm from "./AddTripForm";


const EditMainRouteForm = (props) => {

    console.log(props.route)

    const dateFormatter = (str) => {
        const inputDate = new Date(str);

        const options = {
            year: '2-digit',
            month: '2-digit',
            day: '2-digit',
            hours: '2-digit',
            minutes: '2-digit'
        };

        return inputDate.toLocaleString('en-GB', options);
    }

    const {
        data,
        isLoading,
        setData,
        getData
    } = useGet(`/transport/${props.route.id}/available`)

    !isLoading && console.log(data)

    return (
        <>
            <Row>
                <Col>
                    <AddTripForm transportId={props.route.id} refresh={props.refresh}/>
                </Col>
                <Col>
                    <Container>
                        <Table>
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Од - До</th>
                                <th>Време тргање</th>
                                <th>Време пристигање</th>
                                <th>Број патници</th>
                                <th>Цена</th>
                            </tr>
                            </thead>
                            <tbody>
                            {!isLoading && data != null && data.map((avail) => {
                                return (
                                    avail.routes.map((route, i) => {
                                        return (<tr>
                                            <td>
                                                {i + 1}
                                            </td>
                                            <td>
                                                {route.from} - {route.to}
                                            </td>
                                            <td>
                                                {dateFormatter(route.departure)}
                                            </td>
                                            <td>
                                                {dateFormatter(route.arrival)}
                                            </td>
                                            <td>
                                                {route.freeSpace}
                                            </td>
                                        </tr>)
                            }))})}
                            </tbody>
                        </Table>
                    </Container>
                </Col>
            </Row>
        </>
    )
}

export default EditMainRouteForm