import React from "react";
import Carousel from "react-bootstrap/Carousel";
import Review from "../BecomeAHost/Review";
import {useState} from "react";
import {Container} from "react-bootstrap";
import review from "../BecomeAHost/Review";

const ReviewsCarousel = (props) => {
    document.body.style.backgroundColor = "white";

    const [index, setIndex] = useState(0);

    const handleSelect = (selectedIndex) => {
        setIndex(selectedIndex);
    };
    return (<>
        <Container
            className="py-3 px-1 my-4">
            <Carousel className="w-100" activeIndex={index} onSelect={handleSelect} indicators={false}>
                {props.reviews.length === 0 && <Carousel.Item>
                    <Container>
                        <h4>За избраниот ресурс се уште не се достапни оценки!</h4>
                    </Container>
                </Carousel.Item>}
                {props.reviews.map((rev) => {
                    return (
                        <Carousel.Item>
                            <Review key={review.reviewId} review={rev}></Review>
                        </Carousel.Item>
                    )
                })}
            </Carousel>
        </Container>
    </>)
}

export default ReviewsCarousel;