import React, { useState } from "react";
import { Button, Container, FormControl, FormGroup, FormLabel, Image } from "react-bootstrap";
import useFileChange from "../Hooks/FilesUpload/useFileChange";

const ImageUpload = () => {
    const { onFileChangeHandler } = useFileChange();
    const [selectedFiles, setSelectedFiles] = useState([]);

    return (
        <Container>
            <FormGroup className="mb-3">
                <FormLabel>Upload Images:</FormLabel>
                <FormControl
                    type="file"
                    multiple
                    onChange={(e) => setSelectedFiles(Array.from(e.target.files))}
                />
            </FormGroup>
            <Button onClick={() => onFileChangeHandler(selectedFiles)}>
                Upload Files
            </Button>
            <Container>
                {selectedFiles.map((file, index) => (
                    <Image
                        key={index}
                        onClick={() => {}}
                        fluid
                        src={URL.createObjectURL(file)}
                        alt={`Uploaded Image ${index + 1}`}
                    />
                ))}
            </Container>
        </Container>
    );
};

export default ImageUpload;
