import React from "react";
import {Container, Row, Modal, Image, FormGroup, FormLabel, FormControl, Button} from "react-bootstrap";
import {useState} from "react";
import {AiOutlinePlusCircle} from "react-icons/ai"
import AddHotelForm from "../Forms/AddHotelForm";
import AddRoomForm from "../Forms/AddRoomForm";
import AddRestaurantForm from "../Forms/AddRestaurantForm";
import AddTransportForm from "../Forms/AddTransportForm";
import AddItemMenuForm from "../Forms/AddItemMenuForm";
import AddRoomAvailablityForm from "../Forms/AddRoomAvailablityForm";
import AddTableAvailablityForm from "../Forms/AddTableAvailabilityForm";
import {FaImage} from "react-icons/fa";
import useGet from "../Hooks/useGet";
import useFileChange from "../Hooks/FilesUpload/useFileChange";


const AddImages = (props) => {

    const [show, setShow] = useState(false);
    const {data, isLoading, getData, setData, setChanged} = useGet(`/${props.type}/${props.Id}/images`)
    const { onFileChangeHandler } = useFileChange();
    const [selectedFiles, setSelectedFiles] = useState([]);

    console.log(props.Id)

    const handleClose = () => setShow(false);
    const handleShow = (e) => {
        e.preventDefault();
        setShow(true);

    };

    !isLoading && console.log(data)


    return (<>
        <Container onClick={handleShow}>
            <h5>Слики</h5>
            <div className="d-flex justify-content-center align-content-center"><FaImage size={50}
                                                                                         color="#159895"></FaImage>
            </div>

        </Container>

        {handleShow && <Modal size={'xl'} show={show} onHide={handleClose}>
            <Modal.Header closeButton>
                <Modal.Title style={{color: "#159895"}}>
                    Слики за ресурс
                </Modal.Title>
            </Modal.Header>
            <Modal.Body>
                <Container>
                    {!isLoading && data.map((image) => {
                        let link = image.url;
                        console.log("SLIKATAAA")
                        console.log(image)
                        if (image.url.includes('Desktop')) {
                            link = 'http://localhost:8080/download?fileName=' + encodeURIComponent(image.url);
                        }
                        console.log(link)
                        return (
                            <Image src={link} thumbnail width={171} height={180}/>
                        )
                    })}
                </Container>
                <Container>
                    <FormGroup className="mb-3">
                        <FormLabel>Upload Images:</FormLabel>
                        <FormControl
                            type="file"
                            multiple
                            onChange={(e) => setSelectedFiles(Array.from(e.target.files))}
                        />
                    </FormGroup>
                    <Button onClick={() => {
                        // setChanged((prev) => ++prev)
                        onFileChangeHandler(selectedFiles, props.type, props.Id, setChanged)
                        // setChanged((prev) => ++prev)
                    }}>
                        Upload Files
                    </Button>
                    <Container>
                        {selectedFiles.map((file, index) => (
                            <Image
                                key={index}
                                onClick={() => {
                                }}
                                fluid
                                src={URL.createObjectURL(file)}
                                alt={`Uploaded Image ${index + 1}`}
                            />
                        ))}
                    </Container>
                </Container>
            </Modal.Body>
        </Modal>}
    </>)
}

export default AddImages;