import React from "react";
import { useState } from "react";
import { Col, Container, Row, Image, Modal, Button } from "react-bootstrap";
import Form from "react-bootstrap/Form";
import useCreate from "../Hooks/useCreate";
import Table from "./Table";
import tab from "../Tab/Tab";
const TableRow = (props) => {
    const {createEntity} = useCreate()
    const [getData, setData] = useState(0);
    const [show, setShow] = useState(false);

    const handleClose = () => setShow(false);
    const handleShow = () => setShow(true);
    const table = props.table
    console.log(props)
    console.log(table)
    return (
        <>
            <tr>
                <td>
                    <Table data={table}></Table>
                </td>
                <td>
                    <Form.Select aria-label="Default select example" name={'numberOfBeds'}
                                 onChange={(e) => {
                                     setData(e.target.value);
                                 }}>
                        <option></option>
                        {[...Array(props.data.find(x => x.restaurantTable.tableId === table.tableId).numTables).keys()].map(x => {
                            return (
                                <option value={x+1}  >{x + 1}</option>
                            )
                        })}
                    </Form.Select>
                </td>
                <td>
                    <Button
                        onClick={handleShow}
                        className="m-2"
                        size="md"
                        style={{backgroundColor: "#159895"}}
                    >
                        Резервирај
                    </Button>
                </td>
            </tr>

            <Modal show={show} onHide={handleClose}>
                <Modal.Header closeButton>
                    <Modal.Title>Потврда на резервација</Modal.Title>
                </Modal.Header>
                <Modal.Body>
                    <h3>Резервација на маса во ресторан</h3>
                    <h3>На ден:<b>{' ' + props.params.date}</b></h3>
                    <h3>Време од:<b>{' ' + props.params.hourFrom}</b></h3>
                    <h3>Време до:<b>{' ' + props.params.hourTo}</b></h3>
                    <h3>Маса за {table.noSeats} луѓе</h3>
                </Modal.Body>
                <Modal.Footer>
                    <Button variant="secondary" onClick={handleClose}>
                        Close
                    </Button>
                    <Button variant="primary" onClick={() => {
                        createEntity('restaurant/reserve', {
                            restaurantTableId: table.tableId,
                            userId: 1,
                            restaurantAvailibleId: props.availableId,
                            hourFrom: props.params.hourFrom,
                            hourTo: props.params.hourTo,
                            date: props.params.date
                        })
                        handleClose();
                    }}>
                        Резервирај
                    </Button>
                </Modal.Footer>
            </Modal>
        </>
    )
}

export default TableRow