import React from "react";
import {Container, Form, Button, Row, Col} from "react-bootstrap";
import useFormData from "../Hooks/useFormData";
import {HiMagnifyingGlass} from "react-icons/hi2";


const timeOfArrival = () => {
    let times = [];

    for (let i = 0; i <= 23; i++) {
        for (let j = 0; j <= 30; j += 30) {
            let hour = i.toString().padStart(2, "0");
            let minutes = j.toString().padStart(2, "0");
            times.push(`${hour}:${minutes}`);
        }
    }

    return times;
};

const SearchCriteriasRestaurant = (props) => {

    const {formData, onFormChange, onCheckBoxChange, setFormData} = useFormData(props.criterias)
    const a = timeOfArrival();

    return (
        <>
            <Container
                className="p-1 pb-0 mb-5 mt-3 rounded-2"
                style={{backgroundColor: "#002B5B", width: "65%"}}
            >
                <Form>
                    <Row>
                        <Col>
                            <Form.Floating className="mb-3">
                                <Form.Control
                                    size="lg"
                                    type="text"
                                    placeholder="Место:"
                                    id="location"
                                    name={'restaurantLocation'}
                                    value={formData.restaurantLocation}
                                    onChange={onFormChange}
                                ></Form.Control>
                                <label htmlFor="location">Место:</label>
                            </Form.Floating>
                        </Col>
                        <Col>
                            <Form.Floating className="mb-3">
                                <Form.Control
                                    size="md"
                                    type="date"
                                    step={3600000}
                                    placeholder="Час од:"
                                    id="dateFrom"
                                    name={'date'}
                                    value={formData.date}
                                    onChange={onFormChange}
                                ></Form.Control>
                                <label htmlFor="dateFrom">Датум:</label>
                            </Form.Floating>
                        </Col>
                        <Col>
                            <Form.Floating className="mb-3">
                                <Form.Select size="md"
                                             name={'hourFrom'}
                                             value={formData.hourFrom}
                                             onChange={onFormChange}>
                                    <option>Изберете време:</option>
                                    {a.map((x) => {
                                        return <option key={x}>{x}</option>;
                                    })}
                                </Form.Select>
                                <label htmlFor="hour">Час од:</label>
                            </Form.Floating>
                        </Col>
                        <Col>
                            <Form.Floating className="mb-3">
                                <Form.Select size="md"
                                             name={'hourTo'}
                                             value={formData.hourTo}
                                             onChange={onFormChange}>
                                    <option>Изберете време:</option>
                                    {a.filter((x) => x > formData.hourFrom).map((x) => {
                                        return <option key={x}>{x}</option>;
                                    })}
                                </Form.Select>
                                <label htmlFor="hour">Час до:</label>
                            </Form.Floating>
                        </Col>
                        <Col>
                            <Form.Floating className="mb-3">
                                <Form.Control
                                    size="md"
                                    type="number"
                                    placeholder="Број на гости:"
                                    id="floatingPassengers"
                                    name={'numPeople'}
                                    value={formData.numPeople}
                                    onChange={onFormChange}
                                ></Form.Control>
                                <label htmlFor="floatingPassengers">Број на гости:</label>
                            </Form.Floating>
                        </Col>
                        <Col>
                            <Form.Group className="my-1">
                                <Button type="submit" style={{backgroundColor: "#159895"}} size="lg" onClick={(e) => {
                                    e.preventDefault();
                                    window.location.href = `/search/restaurant/${formData.restaurantLocation}/${formData.date}/${formData.hourFrom}/${formData.hourTo}/${formData.numPeople}`

                                }}>
                                    <span className="ikona my-1"><HiMagnifyingGlass/></span>
                                    <span className="ikona mx-3">Пребарај</span>
                                </Button>
                            </Form.Group>
                        </Col>
                    </Row>
                </Form>
            </Container>
        </>
    );
};

export default SearchCriteriasRestaurant;
