import React from "react";
import { Container, Form, Button, Row, Col } from "react-bootstrap";
import useFormData from "../Hooks/useFormData";

const SearchCriteriasTransport = (props) => {

    const { formData, onFormChange, onCheckBoxChange, setFormData} = useFormData(props.criterias)

    return (
        <>
            <Container
                className="p-1 pb-0 mb-5 mt-3 rounded-2"
                style={{ backgroundColor: "#002B5B", width: "65%"}}
            >
                <Form className="rounded-5">
                    <Row className="gx-1">
                        <Col>
                            <Form.Floating className="mb-3">
                                <Form.Control
                                    size="md"
                                    type="text"
                                    placeholder="Од?:"
                                    id="location"
                                    name="from"
                                    onChange={onFormChange}
                                    value={formData.from}
                                ></Form.Control>
                                <label htmlFor="location">Од:</label>
                            </Form.Floating>
                        </Col>
                        <Col>
                            <Form.Floating className="mb-3">
                                <Form.Control
                                    size="md"
                                    type="text"
                                    placeholder="Од?:"
                                    id="location"
                                    name="to"
                                    onChange={onFormChange}
                                    value={formData.to}
                                ></Form.Control>
                                <label htmlFor="location">До:</label>
                            </Form.Floating>
                        </Col>
                        <Col>
                            <Form.Floating className="mb-3">
                                <Form.Control
                                    size="md"
                                    type="date"
                                    placeholder="Датум на заминување:"
                                    id="dateTo"
                                    name="date"
                                    onChange={onFormChange}
                                    value={formData.date}
                                ></Form.Control>
                                <label htmlFor="dateTo">Датум:</label>
                            </Form.Floating>
                        </Col>
                        <Col>
                            <Form.Floating className="mb-3">
                                <Form.Control
                                    size="md"
                                    type="number"
                                    placeholder="Број на патници:"
                                    id="floatingPassengers"
                                    name="numBeds"
                                    onChange={onFormChange}
                                    value={formData.numPassengers}
                                ></Form.Control>
                                <label htmlFor="floatingPassengers">Број на патници:</label>
                            </Form.Floating>
                        </Col>
                        {props.showButton !== false && <Col>
                            <Form.Group className="my-1">
                                <Button
                                    type="submit"
                                    style={{backgroundColor: "#159895"}}
                                    size="lg"
                                    className="w-100"
                                    onClick={(e) => {
                                        e.preventDefault();
                                        window.location.href = `/search/transport/${formData.from}/${formData.to}/${formData.date}/${formData.numPassengers}`
                                    }}
                                >
                                    <span className="ikona mx-3">Пребарај</span>
                                </Button>
                            </Form.Group>
                        </Col>}
                    </Row>
                </Form>
            </Container>
        </>
    );
};

export default SearchCriteriasTransport;
