import React from "react";
import { Button, Col, Container, Form, Row } from "react-bootstrap";
import { HiMagnifyingGlass } from "react-icons/hi2"
import useFormData from "../Hooks/useFormData";

function TabFormTransport() {

  const { formData, onFormChange, setFormData } = useFormData({
    from: undefined,
    to: undefined,
    date: undefined,
    numPassengers: 0
  })

  return (
    <Form>
      <Row>
        <Col>
          <Form.Floating className="mb-3">
            <Form.Control
              size="md"
              type="text"
              placeholder="Од:"
              id="floatingFrom"
              value={formData.from}
              name={'from'}
              onChange={onFormChange}
            ></Form.Control>
            <label htmlFor="floatingFrom">Од:</label>
          </Form.Floating>
        </Col>
        <Col>
          <Form.Floating className="mb-3">
            <Form.Control
              size="md"
              type="text"
              placeholder="До:"
              id="floatingTo"
              name={'to'}
              value={formData.to}
              onChange={onFormChange}
            ></Form.Control>
            <label htmlFor="floatingTo">До:</label>
          </Form.Floating>
        </Col>
        <Col>
          <Form.Floating className="mb-3">
            <Form.Control
              size="md"
              type="date"
              placeholder="Датум:"
              id="floatingDate"
              name={'date'}
              value={formData.date}
              onChange={onFormChange}
            ></Form.Control>
            <label htmlFor="floatingDate">Датум:</label>
          </Form.Floating>
        </Col>
        <Col>
          <Form.Floating className="mb-3">
            <Form.Control
              size="md"
              type="number"
              placeholder="Број на патници:"
              name={'numPassengers'}
              id="floatingPassengers"
              value={formData.numPassengers}
              onChange={onFormChange}
            ></Form.Control>
            <label htmlFor="floatingPassengers">Број на патници:</label>
          </Form.Floating>
          <Form.Group className="my-1">
            <Button type="submit" style={{backgroundColor: "#159895"}} size="lg" onClick={(e) => {
              e.preventDefault();
              window.location.href = `/search/transport/${formData.from}/${formData.to}/${formData.date}/${formData.numPassengers}`
            }}>
              <span className="ikona my-1"><HiMagnifyingGlass/></span>
              <span className="ikona mx-3">Пребарај</span>
            </Button>
          </Form.Group>
        </Col>
      </Row>
    </Form>
  );
}

export default TabFormTransport;
