import HotelReservationListing from "./HotelReservationListing";
import React from "react";
import useGet from "../Hooks/useGet";

const ActiveTransportReservations = () => {

    const {data, isLoading, setData, getData, setChanged} = useGet('/transport/reservations/user/1')

    return (
        <>
            {!isLoading && data.map((res) => {
                return (<HotelReservationListing data={res} type={'transport'}></HotelReservationListing>)
            })}

            {(!isLoading && data.length === 0) && <h3 className={'my-5'}>Нема податоци за одбраните критериуми!</h3>}
        </>
    )
}

export default ActiveTransportReservations;