import React from "react";
import {useState} from "react";
import {Col, Container, Row, Image, Modal, Button, Form} from "react-bootstrap";
import LoginForm from "../Login/LoginForm";
import ChangePasswordForm from "../Forms/ChangePasswordForm";
import {FaCalendarAlt} from "react-icons/fa";
import {MdBalcony, MdLocationOn} from "react-icons/md";
import AddAvailability from "../Resources/AddAvailability";
import {LuFan} from "react-icons/lu";
import {TbToolsKitchen2} from "react-icons/tb";
import useGet from "../Hooks/useGet";
import data from "bootstrap/js/src/dom/data";
import {AiOutlinePlusCircle} from "react-icons/ai";
import {MdOutlineRateReview} from "react-icons/md";
import useFormData from "../Hooks/useFormData";
import useCreate from "../Hooks/useCreate";
import HotelReservationModal from "./HotelReservationModal";
import ReviewModal from "./ReviewModal";


const HotelReservationListing = (props) => {

    const type = props.type == "hotel" ? "сместувањето" : props.type == "restaurant" ? "ресторанот" : "превозот";
    // const name = props.type == "hotel" ? props.data.hotelName : props.type == "restaurant" ? props.data.restaurantName : props.data.transportName
    // const id = props.type == "hotel" ? props.data.hotelId : props.type == "restaurant" ? props.data.restaurantID : props.data.transportID

    console.log(props.data)
    const dateFormatter = (str) => {
        const inputDate = new Date(str);

        const options = props.type === 'hotel' ? {
            year: 'numeric',
            month: '2-digit',
            day: '2-digit',
            hour12: false,
        } : {
            year: 'numeric',
            month: '2-digit',
            day: '2-digit',
            hour: '2-digit',
            minute: '2-digit',
            hour12: false,
        };

        return inputDate.toLocaleString('de-DE', options);

    }

    console.log(props)

    const [showReview, setShowReview] = useState(false);

    const handleCloseReview = () => setShowReview(false);
    const handleShowReview = () => setShowReview(true);

    const [show, setShow] = useState(false);

    const handleClose = () => setShow(false);
    const handleShow = () => setShow(true);

    return (<>
        <Container onClick={(e) => {
            if (e.target.id !== 'icon') {
                handleShow();
            }
        }} className="py-3 px-1 my-4"
                   style={{
                       border: "4px solid #159895",
                       borderRadius: "1em",
                       boxShadow: "0 3px 5px #159895",
                       maxWidth: "90%",
                   }}>
            <Row>
                <Col className="d-flex justify-content-center">
                    {props.type !== 'transport' && <Image
                        src="https://www.imgacademy.com/sites/default/files/legacyhotel.jpg"
                        style={{
                            height: "8em",
                            borderRadius: "1em",
                            boxShadow: "0 4px 20px lightblue",
                            maxWidth: "100%",
                        }}
                    ></Image>}
                    {props.type === 'transport' && <Image
                        src="https://samsung.teveotecno.com.ar/wp-content/uploads/2022/07/how-to-create-and-draw-custom-routes-with-google-maps_62d4ad146140d.jpeg"
                        style={{
                            height: "8em",
                            borderRadius: "1em",
                            boxShadow: "0 4px 20px lightblue",
                            maxWidth: "80%",
                        }}
                    ></Image>}
                </Col>
                <Col className={'d-flex flex-column justify-content-center'}>
                    {props.type === "hotel" && (<>
                        <h2 style={{textAlign: "left"}}>{props.data.hotelName}</h2>
                        <h5 style={{textAlign: "left"}}>{props.data.hotelLocation}</h5>
                        <h5 style={{textAlign: "left"}}>{dateFormatter(props.data.dateFrom) + ' - ' + dateFormatter(props.data.dateTo)}</h5>
                    </>)}
                    {props.type === "restaurant" && (<>
                        <h2 style={{textAlign: "left"}}>{props.data.restaurantName}</h2>
                        <h5 style={{textAlign: "left"}}>{props.data.restaurantLocation}</h5>
                        <h5 style={{textAlign: "left"}}>{dateFormatter(props.data.dateFrom) + ' - ' + dateFormatter(props.data.dateTo)}</h5>
                    </>)}
                    {props.type === "transport" && (<>
                        <h5 style={{textAlign: "left"}}>{props.data.carBrand + ' ' + props.data.carType}</h5>
                        <h5 style={{textAlign: "left"}}>{props.data.transportRoute.from + ' - ' + props.data.transportRoute.to}</h5>
                        <h5 style={{textAlign: "left"}}>{dateFormatter(props.data.transportRoute.departure) + ' - ' + dateFormatter(props.data.transportRoute.arrival)}</h5>
                        <h5 style={{textAlign: "left"}}>{props.data.owner.name + ' ' + props.data.owner.surname}</h5>
                    </>)}
                </Col>
                {props.type === 'transport' &&
                    <Col className="d-flex flex-column justify-content-center align-content-center">
                        <h3>Вкупна цена: <br></br>{props.data.transportRoute.price}$</h3>
                    </Col>}
                {(props.past) && <Col className="d-flex flex-column justify-content-center align-content-center">
                    {!props.data.reviewed && <Container id={'ocn'} onClick={(e) => {
                        console.log(e.target)
                        if (e.target.id === 'icon') {
                            handleShowReview();
                        }
                    }}>
                        <h5 id={'icon'}>Додади<br/>оценка</h5>
                        <div className="d-flex justify-content-center align-content-center">
                            <MdOutlineRateReview size={50} color="#159895"/></div>

                    </Container>}
                    {props.data.reviewed && <Container>
                        <h5>Веќе имате <br/>оставено оценка<br/>за оваа резервација</h5>
                    </Container>}
                </Col>}
            </Row>
        </Container>
        {props.type === 'hotel' && <HotelReservationModal show={show} handleClose={handleClose} data={props.data}/>}
        <ReviewModal type={props.type} showReview={showReview} handleCloseReview={handleCloseReview} data={props.data}/>
    </>)
}

export default HotelReservationListing;