package com.tourMate.controllers;

import com.tourMate.services.HotelManager;
import com.tourMate.services.ImageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CrossOrigin("*")
@RestController
public class ImageController {

    @Autowired
    HotelManager hotelManager;
    @Autowired
    ImageManager imageManager;

    @PostMapping(value = "/upload/{type}/{id}", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public ResponseEntity<?> uploadImageHotel(@RequestParam List<MultipartFile> files,
                                              @PathVariable Long id,
                                              @PathVariable String type) {

        imageManager.uploadImages(files, id, type);
        return ResponseEntity.ok().build();
    }

    @GetMapping("/download")
    public ResponseEntity<?> downloadFile1(@RequestParam String fileName) throws IOException {

        File file = new File(fileName);
        InputStreamResource resource = new InputStreamResource(new FileInputStream(file));

        return ResponseEntity.ok()
                .header(HttpHeaders.CONTENT_DISPOSITION, "attachment;filename=" + file.getName())
                .contentType(MediaType.APPLICATION_OCTET_STREAM)
                .contentLength(file.length())
                .body(resource);
    }
}