package com.tourMate.dao;

import com.tourMate.entities.Business;
import com.tourMate.entities.User;
import jakarta.transaction.Transactional;

import java.util.List;

public interface BusinessDao {

    @Transactional
    void createBusiness(Business business, long userId);
    List<Business> getUnapprovedBusinessesOfUser(long userId);
    void deleteBusiness(long businessId);
    List<Business> getCreatedBusinesses();
    Business findBusinessById (long businessId);

    @Transactional
    void editBusiness(long businessId, String name, String phone, String address, String edbs, User user, boolean approved);
    boolean hasBusiness(long userId);

    List<Business> getUnapprovedBusinesses();

    void approveBusiness(Business business);
}
