package com.tourMate.dto;

import com.tourMate.entities.Reviews;
import com.tourMate.entities.Transport;
import com.tourMate.entities.TransportRoute;

import java.util.Collection;
import java.util.Date;

public class TransportListingDto {
    private long transportAvailibleId;
    private String from;
    private String to;
    private Date date;
    private int freeSpace;
    private Date time;
    private double price;
    private Collection<String> routes;
    private Collection<TransportRoute> transportRoutes;
    private Collection<Date> times;
    private Transport transport;
    private Collection<Reviews> reviews;
    private double averageScore;
    public TransportListingDto(long transportAvailibleId, String from, String to, Date date, int freeSpace, Date time, double price, Collection<TransportRoute> routes, Transport transport, Collection<Reviews> reviews, double averageScore) {
        this.transportAvailibleId = transportAvailibleId;
        this.from = from;
        this.to = to;
        this.date = date;
        this.freeSpace = freeSpace;
        this.time = time;
        this.price = price;
        this.routes = routes.stream().map(x -> x.getFrom()).distinct().skip(1).toList();
        this.times = routes.stream().map(x -> x.getArrival()).distinct().skip(1).toList();
        this.transport = transport;
        this.transportRoutes = routes;
        this.reviews = reviews;
        this.averageScore = averageScore;
    }

    public long getTransportAvailibleId() {
        return transportAvailibleId;
    }

    public void setTransportAvailibleId(long transportAvailibleId) {
        this.transportAvailibleId = transportAvailibleId;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getFreeSpace() {
        return freeSpace;
    }

    public void setFreeSpace(int freeSpace) {
        this.freeSpace = freeSpace;
    }

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public double getPrice() {
        return price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public Collection<String> getRoutes() {
        return routes;
    }

    public void setRoutes(Collection<String> routes) {
        this.routes = routes;
    }

    public Transport getTransport() {
        return transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public Collection<TransportRoute> getTransportRoutes() {
        return transportRoutes;
    }

    public void setTransportRoutes(Collection<TransportRoute> transportRoutes) {
        this.transportRoutes = transportRoutes;
    }

    public void setTimes(Collection<Date> times) {
        this.times = times;
    }

    public Collection<Date> getTimes() {
        return times;
    }

    public Collection<Reviews> getReviews() {
        return reviews;
    }

    public double getAverageScore() {
        return averageScore;
    }
}
