package com.tourMate.entities;

import jakarta.persistence.*;
import org.jetbrains.annotations.NotNull;

import java.util.Date;

@Entity
@Table(name = "TransportReservation", schema = "public")
public class TransportReservation {
    private long reservationID;
    private TransportRoute transportRoute;
    private Integer noSeats;
    private User user;
    private Boolean reviewed;

    public TransportReservation(TransportRoute transportRoute, Integer noSeats, User user) {
        this.transportRoute = transportRoute;
        this.noSeats = noSeats;
        this.user = user;
        this.reviewed = false;
    }

    public TransportReservation() {
    }

    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "transport_route_id", unique = false, nullable = false, foreignKey = @ForeignKey(name = "fk_ref_od_rezervacii_kon_prevozi"))
    public TransportRoute getTransportRoute() {
        return transportRoute;
    }

    public void setTransportRoute(TransportRoute transportRoute) {
        this.transportRoute = transportRoute;
    }

    public void setNoSeats(Integer noSeats) {
        this.noSeats = noSeats;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "transport_reservation_id", unique = true, nullable = false)
    public long getReservationID() {
        return reservationID;
    }

    public void setReservationID(long reservationID) {
        this.reservationID = reservationID;
    }

    @Column(name = "no_seats", unique = false, nullable = false)
    @NotNull
    public int getNoSeats() {
        return noSeats;
    }

    public void setNoSeats(int noSeats) {
        this.noSeats = noSeats;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "user_id", unique = false, nullable = false, foreignKey = @ForeignKey(name = "fk_ref_od_rezervacii_prevoz_kon_korisnici"))
    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }
    @Column(name="reviewed", unique = false)
    public Boolean getReviewed() {
        return reviewed;
    }

    public void setReviewed(Boolean reviewed) {
        this.reviewed = reviewed;
    }

}
