package com.tourMate.services.impl;

import com.tourMate.controllers.ImageController;
import com.tourMate.services.HotelManager;
import com.tourMate.services.ImageManager;
import com.tourMate.services.RestaurantManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ImageManagerImpl implements ImageManager {

    @Autowired
    HotelManager hotelManager;
    @Autowired
    RestaurantManager restaurantManager;
    private static final Logger logger = LoggerFactory.getLogger(ImageController.class);
    @Override
    public List<String> uploadImages(List<MultipartFile> files, Long id, String type) {
        List<String> filesToAdd = new ArrayList<>();
        try
        {
            Path desktopPath = Paths.get(System.getProperty("user.home"), "Desktop\\images_tm");
            for (MultipartFile file : files) {
                Path filePath = desktopPath.resolve(file.getOriginalFilename());
                System.out.println(filePath);
                file.transferTo(filePath.toFile());
                filesToAdd.add(filePath.toString());
                logger.info(String.format("File name '%s' uploaded successfully.", file.getOriginalFilename()));
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        if(type.equals("hotel"))
        {
            hotelManager.addHotelImage(id, filesToAdd);
        }
        else if(type.equals("restaurant"))
        {
            restaurantManager.addRestaurantImage(id, filesToAdd);
        }
        else if(type.equals("room"))
        {
            hotelManager.addRoomImage(id, filesToAdd);
        }

        return filesToAdd;
    }
}
