package com.tourMate.services;

import com.tourMate.entities.Business;
import com.tourMate.entities.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class MailJobs {
    @Autowired
    private BusinessManager businessManager;
    @Autowired
    private UsersManager usersManager;
    @Autowired
    private MailingService mailingService;

    @Scheduled(cron = "8 0 * * * MON")
    public void execute() {
        List<Business> unapprovedBusinesses = businessManager.getUnapprovedBusinesses();
        if(!unapprovedBusinesses.isEmpty())
        {
            List<User> admins = usersManager.getAdmins().stream().filter(x -> x.getEmail().contains("@")).toList();
            String subject = "Бизниси кои чекаат на одобрување";
            String message = "Почитувани,\n\nВе известуваме дека постојат повеќе бизнис кои чекаат на Ваша одлука за одобрување.\n\nСо почит,\n\nTourMate";
            admins.forEach(x -> mailingService.sendMail(x.getEmail(), subject, message));
        }
    }
}
