CREATE TABLE DESTINACII (
    idDest SERIAL PRIMARY KEY,
    imeLokacija VARCHAR(255) NOT NULL,
    opisLokacija VARCHAR(255),
    tipoviMesta VARCHAR(255) NOT NULL,
    preporachanaSezona VARCHAR(255) NOT NULL,
    prosechnaTemp DECIMAL(5, 2),
    -- geoLokacija GEOGRAPHY(Point, 4326) 
    -- KOORDINATI
    lat DECIMAL(9, 6),   
	lon DECIMAL(9, 6),
    drzhava VARCHAR(255),
    popularnost INT,
    ime VARCHAR(255) NOT NULL,
    opis VARCHAR(255) NOT NULL, 
    idTag INT,
	CONSTRAINT fk_tag_dest FOREIGN KEY (idTag) REFERENCES TAGOVI(idTag)
);

CREATE TABLE KORISNICI (
    idKorisnik SERIAL PRIMARY KEY,
    ime VARCHAR(255) NOT NULL,
    prezime VARCHAR(255) NOT NULL,
    ePoshta VARCHAR(255) NOT NULL UNIQUE,
    telBr VARCHAR(255) NOT NULL,
    datumRagjanje DATE,
    idDest INT,
    CONSTRAINT fk_dest_korisnik FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);

CREATE TABLE STANDARD (
    idKorisnik INT PRIMARY KEY,
    ime VARCHAR(255) NOT NULL,
    prezime VARCHAR(255) NOT NULL,
    ePoshta VARCHAR(255) NOT NULL UNIQUE,
    telBr VARCHAR(255) NOT NULL,
    datumRagjanje DATE,
    CONSTRAINT fk_korisnik_standard FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik)
);

CREATE TABLE PREMIUM (
    idKorisnik INT PRIMARY KEY,
    ime VARCHAR(255) NOT NULL,
    prezime VARCHAR(255) NOT NULL,
    ePoshta VARCHAR(255) NOT NULL UNIQUE,
    telBr VARCHAR(255) NOT NULL,
    datumRagjanje DATE,
    datumKreiranje DATE,
    popust DECIMAL(5, 2),
    CONSTRAINT fk_korisnik_premium FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik)
);

CREATE TABLE RECENZII (
    idRecenzija INT PRIMARY KEY,
    korisnichkoIme VARCHAR(255) NOT NULL,
    kvalitet INT NOT NULL,
    zabeleshka VARCHAR(255),
    datumRecenzija DATE,
    brGlasovi INT,
    idDest INT,
    idKorisnik INT,
    idRezervacija INT,
    CONSTRAINT fk_dest_recenzija FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest),
    CONSTRAINT fk_korisnik_recenzija FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik),
    CONSTRAINT fk_rezervacija_recenzija FOREIGN KEY (idRezervacija) REFERENCES REZERVACII(idRezervacija)
);

CREATE TABLE METEROLOSHKASOSTOJBA (
    idMeteo INT PRIMARY KEY,
    momentTemp DECIMAL(5, 2),
    sostojbaVreme VARCHAR(255) NOT NULL,
    predupreduvanja VARCHAR(255) NOT NULL,
    vlazhnost DECIMAL(5, 2),
    veter DECIMAL(5, 2),
    mesec INT,
    idDest INT,
    CONSTRAINT fk_dest_meteo FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);

CREATE TABLE PAKETI (
    idPaket INT PRIMARY KEY,
    imePaket VARCHAR(255) NOT NULL,
    cena INT NOT NULL,
    pochetok TIMESTAMP NOT NULL,
    kraj TIMESTAMP NOT NULL,
    idDest INT,
    idAktivnost INT,
    idRezervacija INT,
    CONSTRAINT fk_dest_paket FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest),
    CONSTRAINT fk_aktivnost_paket FOREIGN KEY (idAktivnost) REFERENCES AKTIVNOSTI(idAktivnost),
    CONSTRAINT fk_rezervacija_paket FOREIGN KEY (idRezervacija) REFERENCES REZERVACII(idRezervacija)
);

CREATE TABLE AKTIVNOSTI (
    idAktivnost INT PRIMARY KEY,
    imeAktivnost VARCHAR(255) NOT NULL,
    informacii VARCHAR(255),
    kategorija VARCHAR(255) NOT NULL,
    iznos INT,
    idDest INT,
    CONSTRAINT fk_dest_aktivnost FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);

CREATE TABLE REZERVACII (
    idRezervacija INT PRIMARY KEY,
    vremenskaTochka DATE NOT NULL,
    vkupnaCena INT NOT NULL,
    idAktivnost INT,
    idKorisnik INT,
    idMeteo INT,
    CONSTRAINT fk_aktivnost_rezervacija FOREIGN KEY (idAktivnost) REFERENCES AKTIVNOSTI(idAktivnost),
    CONSTRAINT fk_korisnik_rezervacija FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik),
    CONSTRAINT fk_meteo_rezervacija FOREIGN KEY (idMeteo) REFERENCES METEROLOSHKASOSTOJBA(idMeteo)
);

CREATE TABLE PREFERENCI (
    idPreferenca INT PRIMARY KEY,
    tipPreferenca VARCHAR(255) NOT NULL,
    prioritet INT,
    idKorisnik INT,
    CONSTRAINT fk_korisnik_preferenca FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik)
);

CREATE TABLE NASTANI (
    idNastan INT PRIMARY KEY,
    naziv VARCHAR(255) NOT NULL,
    vidovi VARCHAR(255) NOT NULL,
    pochetenDatum DATE,
    kraenDatum DATE,
    detali VARCHAR(255),
    idDest INT,
    CONSTRAINT fk_dest_nastan FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);


CREATE TABLE TAGOVI (
    idTag INT PRIMARY KEY,
    tagOznaka VARCHAR(255) NOT NULL,
    idDest INT,
    CONSTRAINT fk_dest_tag FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);