DROP SCHEMA travel_sage CASCADE;
CREATE SCHEMA travel_sage;                   
SET SEARCH_PATH TO travel_sage;              

DROP TABLE IF EXISTS NASTANI CASCADE;
DROP TABLE IF EXISTS PREFERENCI CASCADE;
DROP TABLE IF EXISTS PAKETI CASCADE;
DROP TABLE IF EXISTS RECENZII CASCADE;
DROP TABLE IF EXISTS REZERVACII CASCADE;
DROP TABLE IF EXISTS PREMIUM CASCADE;
DROP TABLE IF EXISTS STANDARD CASCADE;
DROP TABLE IF EXISTS KORISNICI CASCADE;
DROP TABLE IF EXISTS AKTIVNOSTI CASCADE;
DROP TABLE IF EXISTS METEROLOSHKASOSTOJBA CASCADE;
DROP TABLE IF EXISTS DESTINACII CASCADE;
DROP TABLE IF EXISTS TAGOVI CASCADE;
DROP TABLE IF EXISTS destinacii_has_tagovi CASCADE;
DROP TABLE IF EXISTS aktivnosti_has_paketi CASCADE;
DROP TABLE IF EXISTS aktivnosti_has_rezervacii CASCADE;
DROP TABLE IF EXISTS destinacii_has_korisnici CASCADE;


CREATE TABLE TAGOVI (
    idTag SERIAL PRIMARY KEY,
    tagOznaka VARCHAR(255) NOT NULL
);

CREATE TABLE DESTINACII (
    idDest SERIAL PRIMARY KEY,
    imeLokacija VARCHAR(255) NOT NULL,
    opisLokacija VARCHAR(255),
    tipoviMesta VARCHAR(255) NOT NULL,
    preporachanaSezona VARCHAR(255) NOT NULL,
    prosechnaTemp DECIMAL(5, 2),
    lat DECIMAL(9, 6),   
    lon DECIMAL(9, 6),
    drzhava VARCHAR(255),
    popularnost INT,
    ime VARCHAR(255) NOT NULL,
    opis VARCHAR(255) NOT NULL, 
    idTag INT,
    CONSTRAINT fk_tag_dest FOREIGN KEY (idTag) REFERENCES TAGOVI(idTag)
);

CREATE TABLE METEROLOSHKASOSTOJBA (
    idMeteo SERIAL PRIMARY KEY,
    momentTemp DECIMAL(5, 2),
    sostojbaVreme VARCHAR(255) NOT NULL,
    predupreduvanja VARCHAR(255) NOT NULL,
    vlazhnost DECIMAL(5, 2),
    veter DECIMAL(5, 2),
    mesec INT,
    idDest INT,
    CONSTRAINT fk_dest_meteo FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);

CREATE TABLE AKTIVNOSTI (
    idAktivnost SERIAL PRIMARY KEY,
    imeAktivnost VARCHAR(255) NOT NULL,
    informacii VARCHAR(255),
    kategorija VARCHAR(255) NOT NULL,
    iznos INT,
    idDest INT,
    CONSTRAINT fk_dest_aktivnost FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);

CREATE TABLE KORISNICI (
    idKorisnik SERIAL PRIMARY KEY,
    ime VARCHAR(255) NOT NULL,
    prezime VARCHAR(255) NOT NULL,
    ePoshta VARCHAR(255) NOT NULL UNIQUE,
    telBr VARCHAR(255) NOT NULL,
    datumRagjanje DATE,
    idDest INT,
    CONSTRAINT fk_dest_korisnik FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);

CREATE TABLE STANDARD (
    idKorisnik INT,
    ime VARCHAR(255) NOT NULL,
    prezime VARCHAR(255) NOT NULL,
    ePoshta VARCHAR(255) NOT NULL UNIQUE,
    telBr VARCHAR(255) NOT NULL,
    datumRagjanje DATE,
    CONSTRAINT fk_korisnik_standard FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik)
);

CREATE TABLE PREMIUM (
    idKorisnik INT,
    ime VARCHAR(255) NOT NULL,
    prezime VARCHAR(255) NOT NULL,
    ePoshta VARCHAR(255) NOT NULL UNIQUE,
    telBr VARCHAR(255) NOT NULL,
    datumRagjanje DATE,
    datumKreiranje DATE,
    popust DECIMAL(5, 2),
    CONSTRAINT fk_korisnik_premium FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik)
);

CREATE TABLE REZERVACII (
    idRezervacija SERIAL PRIMARY KEY,
    vremenskaTochka DATE NOT NULL,
    vkupnaCena INT NOT NULL,
    idAktivnost INT,
    idKorisnik INT,
    idMeteo INT,
    CONSTRAINT fk_aktivnost_rezervacija FOREIGN KEY (idAktivnost) REFERENCES AKTIVNOSTI(idAktivnost),
    CONSTRAINT fk_korisnik_rezervacija FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik),
    CONSTRAINT fk_meteo_rezervacija FOREIGN KEY (idMeteo) REFERENCES METEROLOSHKASOSTOJBA(idMeteo)
);

CREATE TABLE RECENZII (
    idRecenzija SERIAL PRIMARY KEY,
    korisnichkoIme VARCHAR(255) NOT NULL,
    kvalitet INT NOT NULL,
    zabeleshka VARCHAR(255),
    datumRecenzija DATE,
    brGlasovi INT,
    idDest INT,
    idKorisnik INT,
    idRezervacija INT,
    CONSTRAINT fk_dest_recenzija FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest),
    CONSTRAINT fk_korisnik_recenzija FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik),
    CONSTRAINT fk_rezervacija_recenzija FOREIGN KEY (idRezervacija) REFERENCES REZERVACII(idRezervacija)
);

CREATE TABLE PAKETI (
    idPaket SERIAL PRIMARY KEY,
    imePaket VARCHAR(255) NOT NULL,
    cena INT NOT NULL,
    pochetok TIMESTAMP NOT NULL,
    kraj TIMESTAMP NOT NULL,
    idDest INT,
    idAktivnost INT,
    idRezervacija INT,
    CONSTRAINT fk_dest_paket FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest),
    CONSTRAINT fk_aktivnost_paket FOREIGN KEY (idAktivnost) REFERENCES AKTIVNOSTI(idAktivnost),
    CONSTRAINT fk_rezervacija_paket FOREIGN KEY (idRezervacija) REFERENCES REZERVACII(idRezervacija)
);

CREATE TABLE PREFERENCI (
    idPreferenca SERIAL PRIMARY KEY,
    tipPreferenca VARCHAR(255) NOT NULL,
    prioritet INT,
    idKorisnik INT,
    CONSTRAINT fk_korisnik_preferenca FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik)
);

CREATE TABLE NASTANI (
    idNastan SERIAL PRIMARY KEY,
    naziv VARCHAR(255) NOT NULL,
    vidovi VARCHAR(255) NOT NULL,
    pochetenDatum DATE,
    kraenDatum DATE,
    detali VARCHAR(255),
    idDest INT,
    CONSTRAINT fk_dest_nastan FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);

CREATE TABLE destinacii_has_tagovi (
  destinacii_idDest INT NOT NULL,
  tagovi_idTag INT NOT NULL,
  PRIMARY KEY (destinacii_idDest, tagovi_idTag),
  FOREIGN KEY (destinacii_idDest) REFERENCES DESTINACII(idDest), 
  FOREIGN KEY (tagovi_idTag) REFERENCES TAGOVI(idTag)
);

CREATE TABLE aktivnosti_has_paketi (
  aktivnosti_idAktivnost INT NOT NULL,
  paketi_idPaket INT NOT NULL,
  PRIMARY KEY (aktivnosti_idAktivnost, paketi_idPaket),
  FOREIGN KEY (aktivnosti_idAktivnost) REFERENCES AKTIVNOSTI(idAktivnost),
  FOREIGN KEY (paketi_idPaket) REFERENCES PAKETI(idPaket)
);

CREATE TABLE aktivnosti_has_rezervacii (
  aktivnosti_idAktivnost INT NOT NULL,
  rezervacii_idRezervacija INT NOT NULL,
  PRIMARY KEY (aktivnosti_idAktivnost, rezervacii_idRezervacija),
  FOREIGN KEY (aktivnosti_idAktivnost) REFERENCES AKTIVNOSTI(idAktivnost),
  FOREIGN KEY (rezervacii_idRezervacija) REFERENCES REZERVACII(idRezervacija)
);

CREATE TABLE destinacii_has_korisnici (
  destinacii_idDest INT NOT NULL,
  korisnici_idKorisnik INT NOT NULL,
  ocena INT NULL,
  komentar VARCHAR(100) NULL,
  datum DATE NULL,
  PRIMARY KEY (destinacii_idDest, korisnici_idKorisnik),
  FOREIGN KEY (destinacii_idDest) REFERENCES DESTINACII(idDest),
  FOREIGN KEY (korisnici_idKorisnik) REFERENCES KORISNICI(idKorisnik)
);
