SET search_path TO travel_sage;

INSERT INTO TAGOVI (tagOznaka) VALUES
('природа'),
('култура'),
('море'),
('летување'),
('планинарски патеки'),
('историја'),
('музика'),
('спорт'),
('авантура'),
('фестивали'),
('архитектура'),
('ноќен живот'),
('риболов'),
('локални атракции'),
('пешачење');


INSERT INTO DESTINACII (imeLokacija, opisLokacija, tipoviMesta, preporachanaSezona, prosechnaTemp, lat, lon, drzhava, popularnost, ime, opis, idTag) VALUES
('Охрид', 'Историски град со прекрасно езеро', 'Град, езеро', 'лето', 20.5, 41.11, 20.8, 'Северна Македонија', 5, 'Заливот на коските', 'Уникатна археолошка локација на брегот на Охридското Езеро, позната по откритието на праисториски населби и голем број коскени остатоци.', 1),
('Скопје', 'Град со древни и модерни атракции', 'Град', 'пролет', 15.0, 41.998, 21.425, 'Северна Македонија', 8, 'Канјон Матка', 'Матка нуди спектакуларни пејзажи, пешачки патеки и можности за возење чамец. Тоа е совршено место за љубителите на природата и авантурите.', 2),
('Барселона', 'Град со неверојатна архитектура и плажи', 'Град, море', 'лето', 25.0, 41.3784, 2.1915, 'Шпанија', 9, 'Саграда Фамилија', 'Прекрасна црква дизајнирана од Антони Гауди, која е незавршена и привлекува милиони туристи годишно.', 3),
('Мадрид', 'Главниот град на Шпанија, богато културно наследство', 'Град', 'пролет', 15.0, 40.4168, -3.7038, 'Шпанија', 8, 'Плаза Мајор', 'Историски плоштад кој е центар на животот во Мадрид.', 4),
('Париз', 'Град на љубовта и модата', 'Град', 'пролет', 18.0, 48.8566, 2.3522, 'Франција', 10, 'Еiffelovата кула', 'Позната структура која се смета за симбол на Франција и е една од најпосетуваните туристички атракции во светот.', 4),
('Ница', 'Град на Азурниот брег', 'Град, плажа', 'лето', 20.0, 43.7102, 7.2620, 'Франција', 6, 'Ница', 'Познат по своите плажи и прекрасната Ривиера.', 1),
('Рим', 'Град со многу историски споменици', 'Град, историја', 'пролет', 20.0, 41.9028, 12.4964, 'Италија', 9, 'Колосеум', 'Антички амфитеатар и една од најголемите историски знаменитости во светот.', 5),
('Венеција', 'Град познат по своите канали и архитектура', 'Град, вода', 'пролет', 17.5, 45.4408, 12.3155, 'Италија', 7, 'Плоштадот Свети Марко', 'Познат по величествениот плоштад и базиликата.', 3),
('Њујорк', 'Град кој никогаш не спие', 'Град', 'пролет', 15.5, 40.7128, -74.0060, 'САД', 10, 'Статуата на слободата', 'Познат симбол на слободата, даруван од Франција, кој стои на влезот во пристаништето на Њујорк.', 6),
('Њу Делхи', 'Град со историски и модерни карактеристики', 'Град, историја', 'зима', 12.0, 28.6139, 77.2090, 'Индија', 7, 'Тадж Махал', 'Голема гробница од бел мрамор која се смета за симбол на љубовта и едно од новите седум чуда на светот.', 7),
('Лондон', 'Град со силно историско и културно наследство', 'Град', 'пролет', 14.5, 51.5074, -0.1278, 'Велика Британија', 8, 'Биг Бен', 'Еден од најпознатите часовници на светот, кој е симбол на Лондон.', 8),
('Токио', 'Град кој ги комбинира традицијата и технологијата', 'Град', 'лето', 23.0, 35.6762, 139.6503, 'Јапонија', 9, 'Свети храм Сензоји', 'Традиционален будистички храм и еден од најстариите и најпознатите храмови во Токио.', 9),
('Атина', 'Град на античката култура', 'Град, историја', 'пролет', 18.5, 37.9838, 23.7275, 'Грција', 7, 'Партенон', 'Антички храм посветен на божицата Атена, еден од најпознатите споменици на светот.', 10);


INSERT INTO METEROLOSHKASOSTOJBA (momentTemp, sostojbaVreme, predupreduvanja, vlazhnost, veter, mesec, idDest) VALUES
(25.5, 'сончево', 'Нема', 60.0, 5.5, 6, 1),
(18.3, 'облачно', 'Можни дождови', 75.0, 7.2, 12, 2),
(30.0, 'сончево', 'Нема', 50.0, 4.0, 7, 3),
(22.0, 'облачно', 'Можни дождови', 80.0, 6.0, 5, 4),
(17.0, 'облачно', 'Лесен дожд', 85.0, 4.5, 1, 5),
(19.5, 'сончево', 'Нема', 55.0, 3.0, 3, 6),
(16.0, 'облачно', 'Можни дождови', 90.0, 5.5, 9, 7),
(28.0, 'сончево', 'Нема', 40.0, 3.2, 8, 8),
(21.0, 'облачно', 'Малку дожд', 78.0, 6.1, 4, 9),
(23.5, 'сончево', 'Нема', 45.0, 3.8, 10, 10);


INSERT INTO AKTIVNOSTI (imeAktivnost, informacii, kategorija, iznos, idDest) VALUES
('Пешачење на планина', 'Туристичка активност за љубителите на природата', 'Активности на отворено', 500, 1),
('Посета на музеи', 'Историски и културни музејски експонати', 'Култура', 300, 2),
('Пливање', 'Популарна летна активност за уживање на морето', 'Активности на плажа', 200, 3),
('Велосипедизам', 'Активност за љубителите на спортот и природата', 'Активности на отворено', 150, 4),
('Посета на историски локалитети', 'Историски и културни атракции', 'Култура', 100, 5),
('Скијање', 'Активност за љубителите на зима и снег', 'Зимски спортови', 800, 6),
('Пешачење по градот', 'Обиколка на историски и културни места во градот', 'Активности на отворено', 250, 7),
('Јога на плажа', 'Спокојна активност за релаксација', 'Активности на плажа', 120, 8),
('Посета на национален парк', 'Природна убавина и активности на отворено', 'Природа', 350, 9),
('Фестивал на храна и вино', 'Празник за љубителите на гастрономијата', 'Активности за храна', 200, 10),
('Голф', 'Активност за рекреација и опуштање', 'Активности на отворено', 600, 3),
('Вино туризам', 'Посета на винариите и дегустација на вино', 'Култура', 700, 6);


INSERT INTO KORISNICI (ime, prezime, ePoshta, telBr, datumRagjanje, idDest) VALUES
('Лука', 'Николов', 'luka.nikolov@mail.com', '071234567', '1994-05-15', 1),
('Емили', 'Димитрова', 'emili.dimitrova@mail.com', '072345678', '1997-07-22', 2),
('Никола', 'Николовски', 'nikola.nikolovski@mail.com', '073456789', '2005-03-30', 3),
('Лара', 'Георгиева', 'lara.georgieva@mail.com', '074567890', '1996-11-11', 4),
('Кејт', 'Радовановиќ', 'kate.radovanovik@mail.com', '075678901', '1994-06-18', 5),
('Никола', 'Јованов', 'nikola.jovanov@mail.com', '076789012', '2003-09-09', 6),
('Алек', 'Петровски', 'alex.petrovsky@mail.com', '077890123', '1993-04-12', 7),
('Миа', 'Јованова', 'mia.jovanova@mail.com', '078901234', '1995-08-21', 8),
('Влатко', 'Тодоров', 'vlatko.todorov@mail.com', '079012345', '1988-12-01', 9),
('Ана', 'Марковска', 'ana.markovska@mail.com', '080123456', '2002-02-14', 10),
('Тео', 'Грозданов', 'teo.grozdanov@mail.com', '081234567', '1999-10-30', 11),
('Тина', 'Костова', 'tina.kostova@mail.com', '082345678', '1994-03-05', 12),
('Никита', 'Стојановиќ', 'nikita.stojanovic@mail.com', '083456789', '2000-01-25', 13);


INSERT INTO STANDARD (idKorisnik, ime, prezime, ePoshta, telBr, datumRagjanje) VALUES
(1, 'Лука', 'Николов', 'luka.nikolov@mail.com', '071234567', '1994-05-15'),
(2, 'Емили', 'Димитрова', 'emili.dimitrova@mail.com', '072345678', '1997-07-22'),
(8, 'Миа', 'Јованова', 'mia.jovanova@mail.com', '078901234', '1995-08-21'),
(9, 'Влатко', 'Тодоров', 'vlatko.todorov@mail.com', '079012345', '1988-12-01'),
(10, 'Ана', 'Марковска', 'ana.markovska@mail.com', '080123456', '2002-02-14'),
(12, 'Тина', 'Костова', 'tina.kostova@mail.com', '082345678', '1994-03-05');


INSERT INTO PREMIUM (idKorisnik, ime, prezime, ePoshta, telBr, datumRagjanje, datumKreiranje, popust) VALUES
(3, 'Никола', 'Николовски', 'nikola.nikolovski@mail.com', '073456789', '2005-03-30', '2025-02-01', 10.0),
(4, 'Лара', 'Георгиева', 'lara.georgieva@mail.com', '074567890', '1996-11-11', '2025-02-01', 15.0),
(5, 'Кејт', 'Радовановиќ', 'kate.radovanovik@mail.com', '075678901', '1994-06-18', '2025-02-01', 12.0),
(6, 'Никола', 'Јованов', 'nikola.jovanov@mail.com', '076789012', '2003-09-09', '2025-02-01', 8.0),
(7, 'Алек', 'Петровски', 'alex.petrovsky@mail.com', '077890123', '1993-04-12', '2025-02-01', 18.0),
(11, 'Тео', 'Грозданов', 'teo.grozdanov@mail.com', '081234567', '1999-10-30', '2025-02-01', 20.0),
(13, 'Никита', 'Стојановиќ', 'nikita.stojanovic@mail.com', '083456789', '2000-01-25', '2025-02-01', 10.0);

INSERT INTO REZERVACII (vremenskaTochka, vkupnaCena, idAktivnost, idKorisnik, idMeteo) VALUES
('2025-06-15', 1500, 1, 1, 1),
('2025-07-20', 800, 2, 2, 2),
('2025-08-10', 2200, 3, 3, 3),
('2025-09-05', 950, 4, 4, 4),
('2025-09-25', 1100, 5, 5, 5),
('2025-10-13', 750, 6, 6, 6),
('2025-11-02', 1350, 7, 7, 7),
('2025-12-12', 550, 8, 8, 8),
('2026-01-19', 1150, 9, 9, 9),
('2026-02-28', 980, 10, 10, 10);


INSERT INTO RECENZII (korisnichkoIme, kvalitet, zabeleshka, datumRecenzija, brGlasovi, idDest, idKorisnik, idRezervacija) VALUES
('luka.nikolov@mail.com', 5, 'Одлично искуство, навистина вреди!', '2025-08-10', 8, 1, 1, 3),
('emili.dimitrova@mail.com', 3, 'Место со потенцијал, но имаше некои проблеми.', '2025-09-05', 6, 2, 2, 4),
('nikola.nikolovski@mail.com', 4, 'Прекрасно, но може да биде подобро организирано.', '2025-09-25', 7, 3, 3, 5),
('lara.georgieva@mail.com', 5, 'Уште една неверојатна посета. Ви благодариме!', '2025-10-15', 12, 4, 4, 6);


INSERT INTO PAKETI (imePaket, cena, pochetok, kraj, idDest, idAktivnost, idRezervacija) VALUES
('Пакет за летување на плажа', 6000, '2025-07-01', '2025-07-15', 1, 3, 3),
('Пакет за зимски одмор на планина', 4500, '2025-12-10', '2025-12-20', 2, 4, 4),
('Пакет за авантуристичко летување', 7000, '2025-08-01', '2025-08-15', 3, 5, 5),
('Пакет за екскурзија по историски места', 5500, '2025-05-10', '2025-05-20', 4, 6, 6);


INSERT INTO PREFERENCI (tipPreferenca, prioritet, idKorisnik) VALUES
('Море', 1, 1),
('Планина', 2, 2),
('Рурални дестинации', 1, 3),
('Егзотични дестинации', 3, 4),
('Планина', 1, 5),
('Историски дестинации', 2, 6);


INSERT INTO NASTANI (naziv, vidovi, pochetenDatum, kraenDatum, detali, idDest) VALUES
('Меѓународен фестивал на музика', 'Музика, Забава', '2025-06-10', '2025-06-12', 'Фестивал на поп и класична музика во Охрид', 1),
('Зимска олимпијада во Скопје', 'Спорт, Зима', '2025-12-05', '2025-12-08', 'Голем спортски настан во Скопје', 2),
('Авантуристички спортови во Прилеп', 'Спорт, Пријателство', '2025-07-15', '2025-07-20', 'Семинар за авантуристички спортови', 3),
('Историски фестивал во Скопје', 'Култура, Историја', '2025-05-20', '2025-05-22', 'Фестивал на историјата на Македонија', 4),
('Охридски фестивал', 'Култура, Музика', '2025-06-01', '2025-06-03', 'Голем културен настан на брегот на Охридското езеро.', 1),
('Барселона Фестивал', 'Архитектура, Музика', '2025-07-05', '2025-07-07', 'Фестивал на современа музика и архитектура во Барселона.', 3),
('Мадридски концерт', 'Музика', '2025-05-15', '2025-05-17', 'Концерт на најпознатите светски музичари во Мадрид.', 4),
('Париз Fashion Week', 'Мода', '2025-09-15', '2025-09-20', 'Глобален настан за новите модни трендови во Париз.', 4),
('Ница летен концерт', 'Музика', '2025-08-01', '2025-08-05', 'Концерт на Ривиерата во Ница.', 1),
('Римски историски фестивал', 'Историја, Култура', '2025-06-10', '2025-06-12', 'Фестивал кој ги слави старите римски традиции во Рим.', 5),
('Венецијански карневал', 'Забава, Култура', '2025-02-10', '2025-02-13', 'Познатиот карневал на водите во Венеција.', 3),
('Њујорк Нова Година', 'Забава', '2025-12-31', '2026-01-01', 'Позната новогодишна прослава во Њујорк.', 6),
('Њу Делхи Историски фестивал', 'Историја, Култура', '2025-11-01', '2025-11-05', 'Фестивал посветен на индиското културно наследство.', 7),
('Лондонски театарски фестивал', 'Култура, Театар', '2025-06-25', '2025-06-30', 'Фестивал на најдобрите театарски претстави во Лондон.', 8),
('Токио технолошки саем', 'Технологија, Иновации', '2025-08-10', '2025-08-12', 'Најновиот технолошки напредок во Токио.', 9),
('Атински историски денови', 'Историја', '2025-05-20', '2025-05-22', 'Голем историски настан во Атина, посветен на античката цивилизација.', 10);


INSERT INTO destinacii_has_tagovi (destinacii_idDest, tagovi_idTag) VALUES
(1, 1),
(2, 2),
(3, 3),
(4, 4),
(5, 5),
(6, 6),
(7, 7),
(8, 8),
(9, 9),
(10, 10);


INSERT INTO aktivnosti_has_paketi (aktivnosti_idAktivnost, paketi_idPaket) VALUES
(1, 1),
(2, 2),
(3, 1),
(4, 2),
(5, 1),
(6, 2),
(7, 1),
(8, 2),
(9, 1),
(10, 2);


INSERT INTO aktivnosti_has_rezervacii (aktivnosti_idAktivnost, rezervacii_idRezervacija) VALUES
(1, 1),
(2, 2),
(3, 1),
(4, 2),
(5, 1),
(6, 2),
(7, 1),
(8, 2),
(9, 1),
(10, 2);


INSERT INTO destinacii_has_korisnici (destinacii_idDest, korisnici_idKorisnik, ocena, komentar, datum) VALUES
(1, 1, 5, 'Прекрасно место, многу убаво!', '2025-06-20'),
(2, 2, 4, 'Добро, но имаше некои мали проблеми.', '2025-07-25'),
(3, 1, 5, 'Не можам да заборавам убавите моменти тука.', '2025-06-15'),
(4, 2, 4, 'Место со многу можности за истражување, но би сакал да имаше повеќе активности.', '2025-07-10'),
(5, 1, 5, 'Неверојатна природа и прекрасно искуство!', '2025-08-05'),
(6, 2, 3, 'Пешачките патеки не беа најдобро обележани, но вкупно беше пријатно.', '2025-08-12'),
(7, 1, 5, 'Градот има многу интересни атракции.', '2025-09-01'),
(8, 2, 4, 'Карневалот беше одличен, но времето не беше добро.', '2025-12-11'),
(9, 1, 5, 'Еден од најдобрите летни настани што сум ги посетила.', '2025-06-20'),
(10, 2, 3, 'Добар настан, но можеше да има подобра организација.', '2025-12-15');



