SET search_path TO travel_sage;

INSERT INTO users (first_name, last_name, email, phone_number, birth_date, is_premium) VALUES
('Лука', 'Николов', 'luka.nikolov@mail.com', '071234567', '1994-05-15', FALSE),
('Емили', 'Димитrova', 'emili.dimitrova@mail.com', '072345678', '1997-07-22', TRUE),
('Никола', 'Николовски', 'nikola.nikolovski@mail.com', '073456789', '2005-03-30', FALSE),
('Лара', 'Георгиева', 'lara.georgieva@mail.com', '074567890', '1996-11-11', TRUE),
('Кејт', 'Радовановиќ', 'kate.radovanovik@mail.com', '075678901', '1994-06-18', FALSE),
('Никола', 'Јованов', 'nikola.jovanov@mail.com', '076789012', '2003-09-09', FALSE),
('Алек', 'Петровски', 'alex.petrovsky@mail.com', '077890123', '1993-04-12', FALSE),
('Миа', 'Јованова', 'mia.jovanova@mail.com', '078901234', '1995-08-21', FALSE),
('Влатко', 'Тодоров', 'vlatko.todorov@mail.com', '079012345', '1988-12-01', FALSE),
('Ана', 'Марковска', 'ana.markovska@mail.com', '080123456', '2002-02-14', FALSE),
('Тео', 'Грозданов', 'teo.grozdanov@mail.com', '081234567', '1999-10-30', FALSE),
('Тина', 'Костова', 'tina.kostova@mail.com', '082345678', '1994-03-05', FALSE),
('Никита', 'Стојановиќ', 'nikita.stojanovic@mail.com', '083456789', '2000-01-25', FALSE);

INSERT INTO standard (id_user) VALUES
(1), (3);

INSERT INTO premium (id_user, date_created, discount) VALUES
(2, '2024-01-01', 10.00),
(4, '2024-02-15', 15.00);

INSERT INTO destination (location_name, location_desc, types_of_places, recommended_season, average_temp, latitude, longitude, country, popularity, important_location_name, important_location_description) VALUES
('Охрид', 'Историски град со езеро', 'Град, езеро', 'лето', 22.5, 41.117, 20.801, 'Северна Македонија', 9, 'Свети Наум', 'Манастир на јужниот брег на езерото'),
('Скопје', 'Главен град со модерни и староградски атракции', 'Град', 'пролет', 18.0, 41.998, 21.425, 'Северна Македонија', 8, 'Кале', 'Средновековна тврдина'),
('Париз', 'Град на светлината и модата', 'Град', 'пролет', 20.0, 48.8566, 2.3522, 'Франција', 10, 'Ајфелова кула', 'Симбол на Париз'),
('Барселона', 'Град со неверојатна архитектура и плажи', 'Град, море', 'лето', 25.0, 41.3784, 2.1915, 'Шпанија', 9, 'Саграда Фамилија', 'Прекрасна црква дизајнирана од Антони Гауди'),
('Мадрид', 'Главниот град на Шпанија, богато културно наследство', 'Град', 'пролет', 15.0, 40.4168, -3.7038, 'Шпанија', 8, 'Плаза Мајор', 'Историски плоштад'),
('Ница', 'Град на Азурниот брег', 'Град, плажа', 'лето', 20.0, 43.7102, 7.2620, 'Франција', 6, 'Ница', 'Познат по плажите'),
('Рим', 'Град со многу историски споменици', 'Град, историја', 'пролет', 20.0, 41.9028, 12.4964, 'Италија', 9, 'Колосеум', 'Антички амфитеатар'),
('Венеција', 'Град познат по своите канали и архитектура', 'Град, вода', 'пролет', 17.5, 45.4408, 12.3155, 'Италија', 7, 'Плоштадот Свети Марко', 'Величествен плоштад'),
('Њујорк', 'Град кој никогаш не спие', 'Град', 'пролет', 15.5, 40.7128, -74.0060, 'САД', 10, 'Статуата на слободата', 'Симбол на слободата'),
('Њу Делхи', 'Град со историски и модерни карактеристики', 'Град, историја', 'зима', 12.0, 28.6139, 77.2090, 'Индија', 7, 'Тадж Махал', 'Гробница од бел мрамор'),
('Лондон', 'Град со силно историско и културно наследство', 'Град', 'пролет', 14.5, 51.5074, -0.1278, 'Велика Британија', 8, 'Биг Бен', 'Часовникот на Лондон'),
('Токио', 'Град кој ги комбинира традицијата и технологијата', 'Град', 'лето', 23.0, 35.6762, 139.6503, 'Јапонија', 9, 'Свети храм Сензоји', 'Традиционален храм'),
('Атина', 'Град на античката култура', 'Град, историја', 'пролет', 18.5, 37.9838, 23.7275, 'Грција', 7, 'Партенон', 'Антички храм');

INSERT INTO tag (tag_name) VALUES
('природа'),
('култура'),
('море'),
('летување'),
('планинарски патеки'),
('историја'),
('музика'),
('спорт'),
('авантура'),
('фестивали'),
('архитектура'),
('ноќен живот'),
('риболов'),
('локални атракции'),
('пешачење'),
('забава');

INSERT INTO destination_tag (id_destination, id_tag) VALUES
(1, 2), (1, 4), (2, 1), (3, 1), (3, 4);

INSERT INTO reservation (id_user, time_point, premium_discount_applied, discount_amount, total_price) VALUES
(1, '2025-01-10 12:00:00', FALSE, 0, 150.00),
(2, '2025-02-05 15:30:00', TRUE, 15.00, 200.00),
(3, '2025-03-12 09:00:00', FALSE, 0, 120.00),
(4, '2025-10-01 10:00:00', TRUE, 15.00, 400.00); 

INSERT INTO review (username, reservation_id, id_destination, quality, comment, review_date, vote_count) VALUES
('luka.nikolov@mail.com', 1, 1, 5, 'Одлично искуство, навистина вреди!', '2025-08-10', 8),
('emili.dimitrova@mail.com', 2, 3, 3, 'Место со потенцијал, но имаше некои проблеми.', '2025-09-05', 4),
('nikola.nikolovski@mail.com', 3, 3, 4, 'Прекрасно, но може да биде подобро организирано.', '2025-09-25', 5),
('lara.georgieva@mail.com', 4, 5, 5, 'Уште една неверојатна посета. Ви благодариме!', '2025-10-15', 12);

INSERT INTO meteorological_condition (id_destination, current_temp, weather_condition, warnings, humidity, wind, month) VALUES
(1, 25.3, 'сончево', 'нема', 60, 5.5, 7),
(2, 15.0, 'облачно', 'дожд', 75, 3.2, 4),
(3, 18.5, 'сончево', 'нема', 55, 4.1, 5),
(11, 25.5, 'сончево', 'нема', 60.0, 5.5, 6),
(12, 18.3, 'облачно', 'можни дождови', 75.0, 7.2, 12),
(13, 30.0, 'сончево', 'нема', 50.0, 4.0, 7),
(4, 22.0, 'облачно', 'можни дождови', 80.0, 6.0, 5),
(5, 17.0, 'облачно', 'лесен дожд', 85.0, 4.5, 1),
(6, 19.5, 'сончево', 'нема', 55.0, 3.0, 3),
(7, 16.0, 'облачно', 'можни дождови', 90.0, 5.5, 9),
(8, 28.0, 'сончево', 'нема', 40.0, 3.2, 8),
(9, 21.0, 'облачно', 'малку дожд', 78.0, 6.1, 4),
(10, 23.5, 'сончево', 'нема', 45.0, 3.8, 10);

INSERT INTO package (package_name, id_destination, price, start_date, end_date) VALUES
('Охридско лето', 1, 300.00, '2025-07-01', '2025-07-15'),
('Скопје тур', 2, 150.00, '2025-05-10', '2025-05-12'),
('Париз викенд', 3, 500.00, '2025-09-01', '2025-09-05'),
('Пакет за летување на плажа', 4, 6000, '2025-07-01', '2025-07-15'),
('Пакет за зимски одмор на планина', 10, 4500, '2025-12-10', '2025-12-20'),
('Пакет за авантуристичко летување', 6, 7000, '2025-08-01', '2025-08-15'),
('Пакет за екскурзија по историски места', 13,  5500, '2025-05-10', '2025-05-20');

INSERT INTO activity (activity_name, id_destination, information, amount, category) VALUES
('Возење со чамец', 1, 'Чамец низ Охридско Езеро', 20.00, 'вода'),
('Пешачење Водно', 2, 'Организирана тура со водич', 10.00, 'пешачење'),
('Турнеја Лувр', 3, 'Посета на музеј', 50.00, 'култура'),
('Пешачење на планина', 13, 'Туристичка активност за љубителите на природата', 500, 'активности на отворено'),
('Посета на музеи', 5, 'Историски и културни музејски експонати', 300, 'култура'),
('Пливање', 6, 'Популарна летна активност за уживање на морето', 200, 'активности на плажа'),
('Велосипедизам', 4, 'Активност за љубителите на спортот и природата', 150, 'активности на отворено'),
('Посета на историски локалитети', 7, 'Историски и културни атракции', 100, 'култура'),
('Скијање', 13, 'Активност за љубителите на зима и снег', 800, 'зимски спортови'),
('Пешачење по градот', 10, 'Обиколка на историски и културни места во градот', 250, 'активности на отворено'),
('Јога на плажа', 6, 'Спокојна активност за релаксација', 120, 'активности на плажа'),
('Посета на национален парк', 12, 'Природна убавина и активности на отворено', 350, 'природа'),
('Фестивал на храна и вино', 13, 'Празник за љубителите на гастрономијата', 200, 'активности за храна'),
('Голф', 9, 'Активност за рекреација и опуштање', 600, 'активности на отворено'),
('Вино туризам', 5, 'Посета на винариите и дегустација на вино', 700, 'култура');


INSERT INTO event (event_name, id_destination, start_date, end_date, details, event_type) VALUES
('Охридско лето', 1, '2025-07-01', '2025-07-15', 'Културен фестивал', 'фестивал'),
('Скопско културно лето', 2, '2025-06-10', '2025-06-20', 'Концерти и изложби', 'култура'),
('Париски моден викенд', 3, '2025-09-01', '2025-09-05', 'Модни ревии', 'мода'),
('Барселона Фестивал', 4, '2025-07-05', '2025-07-07', 'Фестивал на современа музика и архитектура во Барселона.', 'фестивал'),
('Мадридски концерт', 5, '2025-05-15', '2025-05-17', 'Концерт на најпознатите светски музичари во Мадрид.', 'музика'),
('Ница летен концерт', 6, '2025-08-01', '2025-08-05', 'Концерт на Ривиерата во Ница.', 'музика'),
('Римски историски фестивал', 7, '2025-06-10', '2025-06-12', 'Фестивал кој ги слави старите римски традиции во Рим.', 'историја'),
('Венецијански карневал', 8, '2025-02-10', '2025-02-13', 'Познатиот карневал на водите во Венеција.', 'забава'),
('Њујорк Нова Година', 9, '2025-12-31', '2026-01-01', 'Позната новогодишна прослава во Њујорк.', 'забава'),
('Њу Делхи Историски фестивал', 10, '2025-11-01', '2025-11-05', 'Фестивал посветен на индиското културно наследство.', 'историја'),
('Лондонски театарски фестивал', 11, '2025-06-25', '2025-06-30', 'Фестивал на најдобрите театарски претстави во Лондон.', 'култура'),
('Токио технолошки саем', 12, '2025-08-10', '2025-08-12', 'Најновиот технолошки напредок во Токио.', 'технологија'),
('Атински историски денови', 13, '2025-05-20', '2025-05-22', 'Голем историски настан во Атина.', 'историја');

INSERT INTO preference (id_user, priority, type_preference) VALUES
(1, 1, 'култура'),
(2, 2, 'море'),
(3, 1, 'историја'),
(4, 3, 'планина'),
(1, 3, 'рурални дестинации'),
(3, 4, 'егзотични дестинации');

INSERT INTO package_activity (id_package, id_activity) VALUES
(1, 1), (2, 2), (3, 3);

INSERT INTO package_reservation (id_package, id_reservation) VALUES
(1, 1), (2, 2);

INSERT INTO activity_reservation (id_activity, id_reservation) VALUES
(1, 1), (2, 2), (3, 3);

INSERT INTO destination_user (id_destination, id_user, rating, comment, recommendation_date) VALUES
(1, 1, 5, 'Силно препорачувам', '2025-01-12'),
(3, 2, 4, 'Вреди да се посети', '2025-02-06'),
(2, 2, 4, 'Добро, но имаше некои мали проблеми.', '2025-07-25'),
(3, 1, 5, 'Не можам да заборавам убавите моменти тука.', '2025-06-15'),
(4, 2, 4, 'Место со многу можности за истражување.', '2025-07-10'),
(5, 1, 5, 'Неверојатна природа и прекрасно искуство!', '2025-08-05'),
(6, 2, 3, 'Патеките не беа најдобро обележани.', '2025-08-12'),
(7, 1, 5, 'Градот има многу интересни атракции.', '2025-09-01'),
(8, 2, 4, 'Карневалот беше одличен, но времето не беше добро.', '2025-12-11'),
(9, 1, 5, 'Еден од најдобрите летни настани што сум ги посетила.', '2025-06-20');
